/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import gu.simplemq.Channel;
import gu.simplemq.MQConnectionException;
import gu.simplemq.MQRuntimeException;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.pool.BaseMQPool;
import java.util.Collection;
import java.util.Collections;

public abstract class BaseMQSender<C> {
    private static final BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    private static final Function<Object, String> jsonFun = new Function<Object, String>(){

        @Override
        public String apply(Object input) {
            return encoder.toJsonString(input);
        }
    };
    protected final BaseMQPool<C> pool;
    private Function<Object, String> stringSerializer = jsonFun;

    public BaseMQSender(BaseMQPool<C> poolLazy) {
        this.pool = Preconditions.checkNotNull(poolLazy, "poolLazy is null");
    }

    protected abstract void doSend(C var1, String var2, Iterable<String> var3) throws Exception;

    protected <T> void doProduce(Channel<T> channel, Collection<T> c) {
        Preconditions.checkArgument(channel != null, "channel is null");
        Collection<String> jsons = this.asJsons(c);
        if (jsons.isEmpty()) {
            return;
        }
        C client = null;
        try {
            client = this.pool.apply();
            this.doSend(client, channel.name, jsons);
        }
        catch (BaseMQPool.MQPoolException e) {
            throw new MQConnectionException(e);
        }
        catch (Throwable e) {
            Throwables.throwIfInstanceOf(e, MQConnectionException.class);
            Throwables.throwIfInstanceOf(e, MQRuntimeException.class);
            throw new MQRuntimeException(e);
        }
        finally {
            if (client != null) {
                this.pool.free();
            }
        }
    }

    private <T> Collection<String> asJsons(Collection<T> c) {
        if (null == c) {
            return Collections.emptyList();
        }
        Collection<T> iterable = Collections2.filter(c, Predicates.notNull());
        Collection<String> jsons = Collections2.transform(iterable, this.stringSerializer);
        return jsons;
    }

    protected void setStringSerializer(Function<Object, String> stringSerializer) {
        this.stringSerializer = null == stringSerializer ? jsonFun : stringSerializer;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [pool=");
        builder.append(this.pool);
        builder.append("]");
        return builder.toString();
    }
}

