/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.HostAndPort;
import gu.simplemq.Constant;
import gu.simplemq.MQConstProvider;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class BaseMQURI
implements Constant {
    private final URI uri;
    private final MQConstProvider constProvider = this.getConstProvider();

    protected BaseMQURI(String uri) {
        this(URI.create(Preconditions.checkNotNull(Strings.emptyToNull(uri), "uri is null or emtpy")));
    }

    protected BaseMQURI(URI uri) {
        this.uri = this.normalized(uri);
    }

    protected BaseMQURI(String host, Integer port) {
        try {
            this.uri = new URI(this.constProvider.getDefaultSchema(), null, MoreObjects.firstNonNull(host, this.constProvider.getDefaultHost()), MoreObjects.firstNonNull(port, this.constProvider.getDefaultPort()), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected BaseMQURI(HostAndPort hostAndPort) {
        this(hostAndPort.getHost(), hostAndPort.getPort());
    }

    protected abstract MQConstProvider getConstProvider();

    public URI getUri() {
        return this.uri;
    }

    public URI asLocation() {
        try {
            return new URI(this.uri.getScheme(), null, this.uri.getHost(), this.uri.getPort(), this.uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getUsername() {
        return BaseMQURI.getUsername(this.uri);
    }

    public String getPassword() {
        return BaseMQURI.getPassword(this.uri);
    }

    public static String getPassword(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            return userInfo.split(":", 2)[1];
        }
        return null;
    }

    public static String getUsername(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo != null) {
            return userInfo.split(":", 2)[0];
        }
        return null;
    }

    private String convertHost(String host) {
        if ("127.0.0.1".equals(host)) {
            return this.constProvider.getDefaultHost();
        }
        if ("::1".equals(host)) {
            return this.constProvider.getDefaultHost();
        }
        return host;
    }

    private URI normalized(URI uri) {
        try {
            if (null == uri) {
                return URI.create(this.constProvider.getDefaultMQLocation());
            }
            return new URI(MoreObjects.firstNonNull(uri.getScheme(), this.constProvider.getDefaultSchema()), uri.getUserInfo(), MoreObjects.firstNonNull(this.convertHost(uri.getHost()), this.constProvider.getDefaultHost()), uri.getPort() == -1 ? this.constProvider.getDefaultPort() : uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.uri.toString();
    }
}

