/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import gu.simplemq.IAdvisor;
import gu.simplemq.IMQConnParameterSupplier;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.MessageQueueFactorys;
import gu.simplemq.ZeroAdvisor;
import gu.simplemq.pool.BaseMQPool;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public abstract class BaseMessageQueueFactory<P extends BaseMQPool>
implements IMessageQueueFactory {
    protected Map<String, Object> mqConnParams = Collections.emptyMap();
    private volatile HostAndPort hostAndPort;
    protected P pool;
    protected final IAdvisor advisor = new ZeroAdvisor();

    protected BaseMessageQueueFactory() {
    }

    protected abstract void doInit(Map<String, Object> var1);

    protected abstract HostAndPort doGetHostAndPort();

    protected P getPool() {
        return this.checkInitialized().pool;
    }

    @Override
    public boolean initialized() {
        return this.pool != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BaseMessageQueueFactory init(Map<String, Object> properties) {
        if (!this.initialized()) {
            BaseMessageQueueFactory baseMessageQueueFactory = this;
            synchronized (baseMessageQueueFactory) {
                if (!this.initialized()) {
                    this.doInit(properties);
                }
            }
        }
        return this;
    }

    @Override
    public BaseMessageQueueFactory init(IMQConnParameterSupplier supplier) {
        return this.init((Map)Preconditions.checkNotNull(supplier, "supplier is null").getMQConnParameters());
    }

    @Override
    public BaseMessageQueueFactory init(String json) {
        return this.init((Map)MessageQueueFactorys.asMQConnParam(json));
    }

    @Override
    public BaseMessageQueueFactory checkInitialized() {
        Preconditions.checkState(this.initialized(), "current instance is uninitizlied");
        return this;
    }

    @Override
    public BaseMessageQueueFactory asDefaultFactory() {
        MessageQueueFactorys.setDefaultFactory(this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HostAndPort getHostAndPort() {
        if (this.hostAndPort == null) {
            BaseMessageQueueFactory baseMessageQueueFactory = this;
            synchronized (baseMessageQueueFactory) {
                if (this.hostAndPort == null) {
                    this.hostAndPort = this.doGetHostAndPort();
                }
            }
        }
        return this.hostAndPort;
    }

    @Override
    public Map<String, Object> getMQConnParameters() {
        return Maps.newHashMap(this.checkInitialized().mqConnParams);
    }

    @Override
    public BaseMessageQueueFactory setAdvisor(IAdvisor advisor) {
        return this;
    }

    public IAdvisor getAdvisor() {
        return this.advisor;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.pool != null) {
            this.pool.close();
            this.pool = null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName() + " [implementation type=");
        builder.append((Object)this.getImplType());
        builder.append(",mqConnParams=");
        builder.append(this.mqConnParams);
        builder.append("]");
        return builder.toString();
    }
}

