/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import gu.simplemq.KeyExpire;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.utils.CommonUtils;
import gu.simplemq.utils.ILazyInitVariable;
import gu.simplemq.utils.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseTable<V> {
    protected final Predicate<String> alwaysTrue = new Predicate<String>(){

        @Override
        public boolean apply(String key) {
            return true;
        }
    };
    private final Type type;
    protected final boolean isJavaBean;
    protected BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    private Function<V, String> keyHelper;
    private final ILazyInitVariable<List<String>> filedNames = ILazyInitVariable.Factory.makeInstance(new Supplier<List<String>>(){

        @Override
        public List<String> get() {
            return BaseTable.this.doGetFieldNames();
        }
    });
    private final Function<String, V> valueGetter = new Function<String, V>(){

        @Override
        public V apply(String input) {
            return Strings.isNullOrEmpty(input) ? null : (Object)BaseTable.this.get(input);
        }
    };
    protected KeyExpire keyExpire = new KeyExpire();

    public BaseTable(Type type) {
        Preconditions.checkArgument(type instanceof Class || type instanceof ParameterizedType, "invalid type of 'type' :must be Class<?> or ParameterizedType");
        this.type = type;
        this.isJavaBean = TypeUtils.isJavaBean(type);
    }

    public Type getType() {
        return this.type;
    }

    private String keyHelper(V v) {
        if (null == this.keyHelper) {
            throw new UnsupportedOperationException("because of null keyHelper");
        }
        return this.keyHelper.apply(v);
    }

    private void assertJavaBean() {
        if (!this.isJavaBean) {
            throw new UnsupportedOperationException("because of not javabean,");
        }
    }

    protected abstract V doGet(String var1);

    public V get(String key) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return this.doGet(key);
    }

    public Map<String, V> get(String ... keys) {
        LinkedHashMap<String, V> m = new LinkedHashMap<String, V>(16);
        for (String key : CommonUtils.cleanEmptyAsList(keys)) {
            V value;
            if (Strings.isNullOrEmpty(key) || null == (value = this.doGet(key))) continue;
            m.put(key, value);
        }
        return m;
    }

    public <T> Map<T, V> get(Iterable<T> keys) {
        HashMap<T, V> tmMap = Maps.newHashMap();
        if (null != keys) {
            Iterable<T> keyList = Iterables.filter(keys, Predicates.notNull());
            String[] array = Lists.newArrayList(Iterables.transform(keyList, new Function<T, String>(){

                @Override
                public String apply(T input) {
                    return String.valueOf(input);
                }
            })).toArray(new String[0]);
            Map<String, V> m = this.get(array);
            for (T k : keyList) {
                V v = m.get(String.valueOf(k));
                if (null == v) continue;
                tmMap.put(k, v);
            }
        }
        return tmMap;
    }

    public <T> Map<T, V> get(T ... keys) {
        if (null != keys) {
            return this.get((Iterable<T>)Arrays.asList(keys));
        }
        return Collections.emptyMap();
    }

    protected abstract void doSet(String var1, V var2, boolean var3);

    public void set(String key, V value, boolean nx) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        if (null == value) {
            if (!nx) {
                this.remove(key);
            }
        } else if (this.isJavaBean) {
            this.setFields(nx, key, value, new String[0]);
        } else {
            this.doSet(key, value, nx);
        }
    }

    public void set(V value, boolean nx) {
        if (null == value) {
            return;
        }
        this.set(this.keyHelper(value), value, nx);
    }

    protected abstract void doSetField(String var1, String var2, Object var3, boolean var4);

    public void setField(String key, String field, Object value, boolean nx) {
        this.assertJavaBean();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(field), "field is null or empty");
        this.doSetField(key, field, value, nx);
    }

    public void setFields(boolean nx, String key, V obj, String ... fields) {
        this.assertJavaBean();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        if (null == obj) {
            if (!nx) {
                this.remove(key);
            }
            return;
        }
        Map<String, String> json = this.encoder.toJsonMap(obj);
        if (1 == (fields = CommonUtils.cleanEmpty(fields)).length) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(fields[0]), "fields[0] is null or empty");
            this.doSetField(key, fields[0], json.get(fields[0]), nx);
        } else {
            for (String field : fields) {
                if (json.containsKey(field)) continue;
                json.remove(field);
            }
            this.doSetFields(key, json, nx);
        }
    }

    protected abstract void doSetFields(String var1, Map<String, String> var2, boolean var3);

    public void setFields(String key, Map<String, Object> fieldsValues, boolean nx) {
        this.assertJavaBean();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        if (null == fieldsValues || fieldsValues.isEmpty()) {
            return;
        }
        HashMap<String, String> fields = new HashMap<String, String>(16);
        for (Map.Entry<String, Object> entry : fieldsValues.entrySet()) {
            Object value = entry.getValue();
            fields.put(key, null == value ? null : this.encoder.toJsonString(value));
        }
        this.doSetFields(key, fields, nx);
    }

    protected abstract Map<String, Object> doGetFields(String var1, Map<String, Type> var2);

    public Map<String, Object> getFields(String key, Map<String, Type> types) {
        this.assertJavaBean();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        return this.doGetFields(key, types);
    }

    public Map<String, Object> getFields(String key, String ... fields) {
        this.assertJavaBean();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        LinkedHashMap<String, Type> types = new LinkedHashMap<String, Type>();
        for (String field : CommonUtils.cleanEmpty(fields)) {
            types.put(field, null);
        }
        return this.doGetFields(key, types);
    }

    public <T> T getField(String key, String field, Type type) {
        this.assertJavaBean();
        Preconditions.checkArgument(!Strings.isNullOrEmpty(key), "key is null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(field), "field is null or empty");
        return (T)this.doGetFields(key, Collections.singletonMap(field, type)).get(field);
    }

    public <T> T getField(String key, String field, Class<T> clazz) {
        return this.getField(key, field, (Type)clazz);
    }

    public <T> T getField(String key, String field) {
        return this.getField(key, field, (Type)null);
    }

    protected abstract int doRemove(String ... var1);

    public int remove(String ... keys) {
        List<String> list = CommonUtils.cleanEmptyAsList(keys);
        return list.isEmpty() ? 0 : this.doRemove(list.toArray(new String[list.size()]));
    }

    public int removeValues(V ... values) {
        List<String> keys = Lists.transform(CommonUtils.cleanNullAsList(values), new Function<V, String>(){

            @Override
            public String apply(V input) {
                return BaseTable.this.keyHelper(input);
            }
        });
        return this.remove(keys.toArray(new String[keys.size()]));
    }

    protected abstract Set<String> doKeys(String var1);

    public Set<String> keys(String pattern) {
        if (Strings.isNullOrEmpty(pattern)) {
            pattern = "*";
        }
        return this.doKeys(pattern);
    }

    protected abstract void doSet(Map<String, V> var1, boolean var2);

    public void set(Map<String, V> m, boolean nx) {
        if (null == m || m.isEmpty()) {
            return;
        }
        this.doSet(m, nx);
    }

    public int size(String pattern) {
        return this.keys(pattern).size();
    }

    public boolean isEmpty() {
        return 0 == this.size(null);
    }

    public boolean containsKey(String key) {
        return Strings.isNullOrEmpty(key) ? false : this.get(key) != null;
    }

    public boolean containsValue(String pattern, final V v) {
        if (null == v) {
            return false;
        }
        return Iterators.tryFind(this.keys(pattern).iterator(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return v.equals(BaseTable.this.get(input));
            }
        }).isPresent();
    }

    public Map<String, V> values(String pattern, Predicate<String> filter) {
        return Maps.asMap(Sets.filter(this.keys(pattern), Preconditions.checkNotNull(filter)), this.valueGetter);
    }

    public Map<String, V> valuesV(String pattern, Predicate<V> filter) {
        return Maps.filterValues(Maps.asMap(this.keys(pattern), this.valueGetter), Preconditions.checkNotNull(filter, "filter is null"));
    }

    public int foreach(String pattern, Predicate<String> action) {
        int count = 0;
        action = MoreObjects.firstNonNull(action, Predicates.alwaysTrue());
        for (String key : this.keys(pattern)) {
            if (!action.apply(key)) continue;
            ++count;
        }
        return count;
    }

    public int foreachValue(String pattern, Predicate<V> action) {
        int count = 0;
        action = MoreObjects.firstNonNull(action, Predicates.alwaysTrue());
        for (String key : this.keys(pattern)) {
            V v = this.valueGetter.apply(key);
            if (v == null || !action.apply(v)) continue;
            ++count;
        }
        return count;
    }

    public int removeKeys(String pattern, final Predicate<String> filter) {
        final AtomicInteger count = new AtomicInteger(0);
        this.foreach(pattern, new Predicate<String>(){

            @Override
            public boolean apply(String key) {
                if (null == filter || filter.apply(key)) {
                    count.addAndGet(BaseTable.this.remove(key));
                }
                return false;
            }
        });
        return count.get();
    }

    public int clear() {
        Set<String> keys = this.doKeys("*");
        return this.remove(keys.toArray(new String[0]));
    }

    public void set(Collection<V> c, boolean nx) {
        if (null == c || c.isEmpty()) {
            return;
        }
        if (null == this.keyHelper) {
            throw new UnsupportedOperationException("because of null keyHelper");
        }
        HashMap<String, V> keysValues = new HashMap<String, V>(16);
        for (V value : c) {
            keysValues.put(this.keyHelper(value), value);
        }
        this.set((Map<String, V>)keysValues, false);
    }

    public void set(boolean nx, V ... array) {
        if (null == array) {
            return;
        }
        this.set((Collection<V>)Arrays.asList(array), nx);
    }

    public BaseJsonEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(BaseJsonEncoder encoder) {
        this.encoder = encoder;
    }

    public Function<V, String> getKeyHelper() {
        return this.keyHelper;
    }

    public void setKeyHelper(Function<V, String> keyHelper) {
        this.keyHelper = keyHelper;
    }

    protected abstract List<String> doGetFieldNames();

    public List<String> getFieldNames() {
        this.assertJavaBean();
        return this.filedNames.get();
    }

    public void setExpire(long duration, TimeUnit unit) {
        this.keyExpire.setExpire(duration, unit);
    }

    public void setExpire(Date date) {
        this.keyExpire.setExpire(date);
    }

    public void setExpire(boolean timestamp, long timeMills) {
        this.keyExpire.setExpire(timestamp, timeMills);
    }

    public void expire(String key, long timeMills, boolean timestamp) {
        this.keyExpire.expire(key, timeMills, timestamp);
    }

    public void expire(String key, long duration, TimeUnit unit) {
        this.keyExpire.expire(key, duration, unit);
    }

    public void expire(String key, Date date) {
        this.keyExpire.expire(key, date);
    }

    public void expire(String key) {
        this.keyExpire.expire(key);
    }

    public void expireValue(V value, long timeMills, boolean timestamp) {
        this.keyExpire.expire(this.keyHelper(value), timeMills, timestamp);
    }

    public void expireValue(V value, long duration, TimeUnit unit) {
        this.keyExpire.expire(this.keyHelper(value), duration, unit);
    }

    public void expireValue(V value, Date date) {
        this.keyExpire.expire(this.keyHelper(value), date);
    }

    public void expireValue(V value) {
        this.keyExpire.expire(this.keyHelper(value));
    }
}

