/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import gu.simplemq.Constant;
import gu.simplemq.IMQContext;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.MessageQueueType;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ServiceLoader;

public class MQContextLoader
implements Constant {
    private static final ImmutableMultimap<MessageQueueType, IMQContext> contexts;
    static final ImmutableMap<MessageQueueType, IMessageQueueFactory> factories;

    private MQContextLoader() {
    }

    public static IMQContext getMQContext(MessageQueueType implType) {
        Collection c = contexts.get((Object)implType);
        switch (((AbstractCollection)c).size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (IMQContext)Lists.newArrayList(c).get(0);
            }
        }
        logger.warn("Multiple entries with same key: {},first instance returned", (Object)implType);
        return (IMQContext)Lists.newArrayList(c).get(0);
    }

    public static Collection<IMQContext> getMQContexts(MessageQueueType implType) {
        return contexts.get((Object)implType);
    }

    public static IMQContext getMQContextChecked(MessageQueueType implType) {
        return Preconditions.checkNotNull(MQContextLoader.getMQContext(implType), "NOT FOUND Context instance for %s", (Object)implType);
    }

    public static IMQContext getMQContext(MessageQueueType implType, final String clientImplType) {
        Collection c = contexts.get((Object)implType);
        Optional<IMQContext> found = Iterables.tryFind(c, new Predicate<IMQContext>(){

            @Override
            public boolean apply(IMQContext input) {
                return Objects.equal(input.getClientImplType(), clientImplType);
            }
        });
        return found.orNull();
    }

    public static IMQContext getMQContextChecked(MessageQueueType implType, String clientImplType) {
        return Preconditions.checkNotNull(MQContextLoader.getMQContext(implType, clientImplType), "NOT FOUND Context instance for %s:%s", (Object)implType, (Object)clientImplType);
    }

    static {
        ImmutableMultimap.Builder<MessageQueueType, IMQContext> builder = ImmutableMultimap.builder();
        ImmutableMap.Builder<MessageQueueType, IMessageQueueFactory> factoryBuilder = ImmutableMap.builder();
        ServiceLoader<IMQContext> providers = ServiceLoader.load(IMQContext.class);
        for (IMQContext c : providers) {
            builder.put(c.getMessageQueueType(), c);
            factoryBuilder.put(c.getMessageQueueType(), c.getMessageQueueFactory());
        }
        contexts = builder.build();
        factories = factoryBuilder.build();
    }
}

