/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import gu.simplemq.Constant;
import gu.simplemq.utils.TypeConversionSupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public enum MQLocationType implements Constant
{
    DEFAULT("uri", "host", "port"),
    PUBSUB("pubsub.uri", "pubsub.host", "pubsub.port"),
    QUEUE("queue.uri", "queue.host", "queue.port"),
    WS("ws.uri", "ws.host", "ws.port");

    public final String uriKey;
    public final String hostKey;
    public final String portKey;

    private MQLocationType(String uriKey, String hostKey, String portKey) {
        this.uriKey = uriKey;
        this.hostKey = hostKey;
        this.portKey = portKey;
    }

    public String locationStringOf(Map props, boolean withDefault, String ... otherKeys) {
        String s;
        if (null == props) {
            return null;
        }
        if (props.get(this.hostKey) != null || props.get(this.portKey) != null) {
            try {
                String schema = null;
                if (this.equals(PUBSUB) && TypeConversionSupport.convert(props.get("pubsub.mqtt"), Boolean.TYPE).booleanValue()) {
                    schema = "mqtt";
                }
                return new URI(schema, null, TypeConversionSupport.stringValueOf(props, this.hostKey), MoreObjects.firstNonNull(TypeConversionSupport.intValueOf(props, this.portKey), -1), null, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        Object v = props.get(this.uriKey);
        if (v instanceof String && !((String)v).isEmpty()) {
            return (String)v;
        }
        if (null != v) {
            return v.toString();
        }
        if (withDefault && !this.equals(DEFAULT) && !this.equals(WS) && !Strings.isNullOrEmpty(s = DEFAULT.locationStringOf(props, false, otherKeys))) {
            return s;
        }
        if (otherKeys != null) {
            for (String key : otherKeys) {
                if (Strings.isNullOrEmpty(key) || key.equals(this.uriKey)) continue;
                v = props.get(key);
                if (v instanceof String && !((String)v).isEmpty()) {
                    return (String)v;
                }
                if (null == v) continue;
                return v.toString();
            }
        }
        return null;
    }

    public URI locationOf(Map props, boolean withDefault, String ... otherKeys) {
        String uri = this.locationStringOf(props, withDefault, otherKeys);
        return null == uri ? null : URI.create(uri);
    }
}

