/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import gu.simplemq.MQConstProvider;
import gu.simplemq.MQLocationType;
import gu.simplemq.MQPropertiesHelper;
import java.net.URI;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public abstract class MQProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private MQPropertiesHelper helper = this.getPropertiesHelper();
    private MQConstProvider constProvider = this.helper.getConstProvider();

    public MQProperties() {
    }

    public MQProperties(Properties defaults) {
        super(defaults);
    }

    public abstract MQPropertiesHelper getPropertiesHelper();

    public MQProperties normalizeLocation() {
        return this.helper.normalizeLocation(this);
    }

    public String getLocationAsString() {
        return this.helper.getLocationAsString(this);
    }

    public URI getLocation() {
        return this.helper.getLocation(this);
    }

    public HostAndPort getHostAndPort() {
        return this.helper.getHostAndPort(this);
    }

    public MQProperties initURI(URI uri) {
        this.setProperty(this.constProvider.getMainLocationName(), Preconditions.checkNotNull(uri, "uri is null").toString());
        return this;
    }

    public MQProperties initURI(String uri) {
        this.setProperty(this.constProvider.getMainLocationName(), Preconditions.checkNotNull(uri, "uri is null"));
        return this;
    }

    public MQProperties init(Map map) {
        this.clear();
        if (map instanceof Properties) {
            Properties props = (Properties)map;
            Enumeration<?> itor = props.propertyNames();
            while (itor.hasMoreElements()) {
                String key = (String)itor.nextElement();
                this.put(key, props.get(key).toString());
            }
        } else if (null != map) {
            this.putAll((Map<?, ?>)map);
        }
        return this;
    }

    public MQProperties with(MQLocationType type) {
        this.helper.with(type);
        return this;
    }

    public <E extends Enum<E>> EnumMap<E, Object> asEnumMap(Class<E> keyType, boolean removeIfSet, String strippedPrefix) {
        return this.helper.asEnumMap(keyType, this, removeIfSet, strippedPrefix);
    }

    public <E extends Enum<E>> EnumMap<E, Object> asEnumMap(Class<E> keyType) {
        return this.asEnumMap(keyType, false, null);
    }
}

