/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.net.HostAndPort;
import gu.simplemq.BaseMQURI;
import gu.simplemq.Constant;
import gu.simplemq.MQConstProvider;
import gu.simplemq.MQLocationType;
import gu.simplemq.MQProperties;
import gu.simplemq.utils.TypeConversionSupport;
import gu.simplemq.utils.URISupport;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class MQPropertiesHelper
implements Constant {
    private static final ThreadLocal<MQLocationType> locationType = new ThreadLocal();
    protected MQConstProvider constProvider = this.getConstProvider();

    protected MQPropertiesHelper() {
    }

    public abstract MQConstProvider getConstProvider();

    public MQProperties makeMQProperties(Properties defaults) {
        return new MQPropertiesImpl(defaults);
    }

    public MQPropertiesHelper with(MQLocationType type) {
        if (type != null) {
            locationType.set(type);
        } else {
            locationType.remove();
        }
        return this;
    }

    private static String connInfoOf(Map props, String ... keys) {
        if (null == props) {
            return null;
        }
        if (keys != null) {
            for (String key : Sets.newLinkedHashSet(Iterables.filter(Arrays.asList(keys), Predicates.notNull()))) {
                String temp = TypeConversionSupport.stringValueOf(props, key);
                if (Strings.isNullOrEmpty(temp)) continue;
                return temp;
            }
        }
        return null;
    }

    public String usernameOf(Map props) {
        return MQPropertiesHelper.connInfoOf(props, "username", this.constProvider.getMainUserName());
    }

    public String passwordOf(Map props) {
        return MQPropertiesHelper.connInfoOf(props, "password", this.constProvider.getMainPassword());
    }

    public String clientidOf(Map props) {
        return MQPropertiesHelper.connInfoOf(props, "clientID", this.constProvider.getMainClientID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getLocation(Map props) {
        try {
            String temp = MoreObjects.firstNonNull(locationType.get(), MQLocationType.DEFAULT).locationStringOf(props, true, this.constProvider.getOptionalLocationNames());
            if (temp != null) {
                URI uRI = new MQLocation(temp).getUri();
                return uRI;
            }
            URI uRI = null;
            return uRI;
        }
        finally {
            locationType.remove();
        }
    }

    public String getLocationAsString(Map props) {
        URI uri = this.getLocation(props);
        return uri == null ? null : uri.toString();
    }

    <M extends Map> M normalizeLocation(M props) {
        if (null != props) {
            String s = TypeConversionSupport.stringValueOf(props, this.constProvider.getMainLocationName());
            if (Strings.isNullOrEmpty(s)) {
                props.put((String)this.constProvider.getMainLocationName(), (String)MoreObjects.firstNonNull(this.getLocationAsString(props), this.constProvider.getDefaultMQLocation()));
            }
            props.remove("queue.uri");
            props.remove("queue.host");
            props.remove("queue.port");
            props.remove("pubsub.uri");
            props.remove("pubsub.host");
            props.remove("pubsub.port");
            props.remove("uri");
            props.remove("host");
            props.remove("port");
            for (String name : this.constProvider.getOptionalLocationNames()) {
                if (this.constProvider.getMainLocationName().equals(name)) continue;
                props.remove(name);
            }
        }
        return props;
    }

    private <M extends Map> M normalizeKey(M props, String nativeKey, String generalKey) {
        if (null != props && nativeKey != null && generalKey != null && !generalKey.equals(nativeKey)) {
            String s = TypeConversionSupport.stringValueOf(props, nativeKey);
            if (Strings.isNullOrEmpty(s) && !Strings.isNullOrEmpty(s = TypeConversionSupport.stringValueOf(props, generalKey))) {
                props.put((String)nativeKey, (String)s);
            }
            props.remove(generalKey);
        }
        return props;
    }

    public <M extends Map> M normalizeProps(M props) {
        this.normalizeLocation(props);
        this.normalizeKey(props, this.constProvider.getMainUserName(), "username");
        this.normalizeKey(props, this.constProvider.getMainPassword(), "password");
        this.normalizeKey(props, this.constProvider.getMainClientID(), "clientID");
        this.normalizeKey(props, this.constProvider.getMainTimeout(), "timeoutMills");
        return props;
    }

    public MQProperties initParameters(Map props) {
        MQProperties params = this.asMQProperties(this.constProvider.getDefaultMQProperties());
        if (null != props) {
            Map<Object, Object> filtered = Maps.filterValues(this.asMQProperties(props), Predicates.notNull());
            params.putAll(filtered);
            URI uri = this.getLocation(params);
            String userinfo = uri.getUserInfo();
            if (userinfo != null && userinfo.indexOf(58) >= 0) {
                String[] u = userinfo.split(":");
                if (!Strings.isNullOrEmpty(u[0])) {
                    String keyUsername = MoreObjects.firstNonNull(this.constProvider.getMainUserName(), "username");
                    params.setProperty(keyUsername, u[0]);
                }
                if (!Strings.isNullOrEmpty(u[1])) {
                    String keyPassword = MoreObjects.firstNonNull(this.constProvider.getMainPassword(), "password");
                    params.setProperty(keyPassword, u[1]);
                }
                try {
                    uri = URISupport.changeUserinfo(uri, null);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            params.initURI(new MQLocation(uri).toString());
        }
        return this.normalizeProps(params);
    }

    public MQProperties asMQProperties(Map props) {
        if (props instanceof MQProperties) {
            return (MQProperties)props;
        }
        return new MQPropertiesImpl().init(props);
    }

    public HashMap<String, String> asMqParameters2(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        HashMap<String, String> map = Maps.newHashMap();
        Enumeration<?> itor = props.propertyNames();
        while (itor.hasMoreElements()) {
            String key = (String)itor.nextElement();
            map.put(key, props.get(key).toString());
        }
        return map;
    }

    public <E extends Enum<E>> EnumMap<E, Object> asEnumMap(Class<E> keyType, Map props, boolean removeIfSet, String strippedPrefix) {
        EnumMap map = new EnumMap(keyType);
        if (props != null) {
            Iterator itor = props.keySet().iterator();
            while (itor.hasNext()) {
                try {
                    Object key = itor.next();
                    Object value = props.get(key);
                    if (keyType.isInstance(key)) {
                        map.put((E)((Enum)key), value);
                    } else {
                        String name = key.toString();
                        if (strippedPrefix != null && name.startsWith(strippedPrefix)) {
                            name = name.substring(strippedPrefix.length());
                        }
                        E ekey = Enum.valueOf(keyType, name);
                        map.put(ekey, value);
                    }
                    if (!removeIfSet) continue;
                    itor.remove();
                }
                catch (Throwable throwable) {}
            }
        }
        return map;
    }

    public HostAndPort getHostAndPort(Map parameters) {
        Preconditions.checkArgument(null != parameters, "parameters is null");
        URI uri = this.getLocation(parameters);
        Preconditions.checkArgument(uri != null, "NOT DEFINED LOCATION FOR MQLocationType:%s", (Object)locationType.get());
        return HostAndPort.fromParts(uri.getHost(), uri.getPort());
    }

    public URI getCanonicalURI(Map parameters) {
        MQProperties props = this.initParameters(parameters);
        return new MQLocation(props.getProperty(this.constProvider.getMainLocationName())).getUri();
    }

    public URI getLocationlURI(Map parameters) {
        MQProperties props = this.initParameters(parameters);
        return new MQLocation(props.getProperty(this.constProvider.getMainLocationName())).asLocation();
    }

    public abstract void checkConnect(Properties var1, Integer var2) throws Exception;

    public abstract boolean testConnect(Properties var1, Integer var2);

    protected class MQPropertiesImpl
    extends MQProperties {
        MQPropertiesImpl() {
        }

        MQPropertiesImpl(Properties defaults) {
            super(defaults);
        }

        @Override
        public MQPropertiesHelper getPropertiesHelper() {
            return MQPropertiesHelper.this;
        }
    }

    protected class MQLocation
    extends BaseMQURI {
        public MQLocation(String uri) {
            super(uri);
        }

        public MQLocation(URI uri) {
            super(uri);
        }

        @Override
        protected MQConstProvider getConstProvider() {
            return MQPropertiesHelper.this.constProvider;
        }
    }
}

