/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import gu.simplemq.Constant;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.MQContextLoader;
import gu.simplemq.MessageQueueType;
import gu.simplemq.json.BaseJsonEncoder;
import java.lang.reflect.Type;
import java.util.Map;

public class MessageQueueFactorys
implements Constant {
    private static volatile IMessageQueueFactory defaultFactory = null;

    private MessageQueueFactorys() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean setDefaultFactory(IMessageQueueFactory defaultFactory) {
        if (MessageQueueFactorys.defaultFactory == null) {
            Class<MessageQueueFactorys> clazz = MessageQueueFactorys.class;
            // MONITORENTER : gu.simplemq.MessageQueueFactorys.class
            if (MessageQueueFactorys.defaultFactory == null) {
                if (defaultFactory != null) {
                    Preconditions.checkArgument(defaultFactory.initialized(), "input defaultFactory is uninitialized");
                    MessageQueueFactorys.defaultFactory = defaultFactory;
                    // MONITOREXIT : clazz
                    return true;
                }
                logger.warn("input argument 'defaultFactory' is null");
                // MONITOREXIT : clazz
                return false;
            }
            // MONITOREXIT : clazz
        }
        logger.warn("INVALID INVOCATION,default factory was initialized already before this invocation");
        return false;
    }

    public static IMessageQueueFactory getDefaultFactory() {
        return Preconditions.checkNotNull(defaultFactory, "defaultFactory is uninitialized");
    }

    public static boolean defaultFactoryInitialized() {
        return defaultFactory != null;
    }

    public static ImmutableMap<MessageQueueType, IMessageQueueFactory> getFactories() {
        Preconditions.checkState(MQContextLoader.factories.size() > 0, "NOT FOUND instance of %s", (Object)IMessageQueueFactory.class.getName());
        return MQContextLoader.factories;
    }

    public static IMessageQueueFactory getFactory(String implType) {
        return MessageQueueFactorys.getFactory(MessageQueueType.valueOf(implType));
    }

    public static IMessageQueueFactory getFactory(MessageQueueType implType) {
        return Preconditions.checkNotNull(MessageQueueFactorys.getFactories().get((Object)implType), "INVALID impltype,INVALID VALUES:%s", (Object)Joiner.on(".").join(MessageQueueFactorys.getFactories().keySet()));
    }

    public static Map<String, Object> asMQConnParam(String json) {
        Type paramType = new TypeToken<Map<String, Object>>(){}.getType();
        return (Map)BaseJsonEncoder.getEncoder().fromJson(json, paramType);
    }

    public static Map<String, String> asMQConnParam2(String json) {
        Type paramType = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)BaseJsonEncoder.getEncoder().fromJson(json, paramType);
    }

    public static void closeAllFactories() {
        for (IMessageQueueFactory factory : MessageQueueFactorys.getFactories().values()) {
            try {
                factory.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

