/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq;

import gu.simplemq.Channel;
import gu.simplemq.MessageAck;
import gu.simplemq.exceptions.SmqRuntimeException;

public class SimplemqContext {
    public static final ThreadLocal<SimplemqContext> context = new ThreadLocal();
    Channel<?> currentChannel;
    MessageAck messageAck;

    SimplemqContext() {
    }

    static void setChannel(Channel<?> currentChannel) {
        SimplemqContext.getCurrentContext().currentChannel = currentChannel;
    }

    public String getCurrentChannelName() {
        return this.currentChannel != null ? this.currentChannel.name : null;
    }

    public Channel<?> getCurrentChannel() {
        return this.currentChannel;
    }

    public MessageAck getMessageAck() {
        return this.messageAck;
    }

    public SimplemqContext setMessageAck(MessageAck messageAck) {
        this.messageAck = messageAck;
        return this;
    }

    public void acknowledge() throws SmqRuntimeException {
        if (null != this.messageAck) {
            this.messageAck.acknowledge();
        }
    }

    public static SimplemqContext getCurrentContext() {
        SimplemqContext c = context.get();
        if (c == null) {
            c = new SimplemqContext();
            context.set(c);
        }
        return c;
    }

    public static void setCurrentContext(SimplemqContext c) {
        context.set(c);
    }
}

