/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import gu.simplemq.jms.JMSReconnectCallback;
import gu.simplemq.jms.JmsConstants;
import java.util.Timer;
import java.util.TimerTask;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

class AutoReconnectAdapter
implements ExceptionListener,
JmsConstants {
    private static final long START_RECONNECTDELAY = 1L;
    private static final long MAX_RECONNECT_DELAY = 128L;
    private static final Timer reconnectTimer = new Timer("AMQP Reconnect");
    private long reconnectDelay = 1L;
    private final JMSReconnectCallback jmsReconnectCallback;

    AutoReconnectAdapter(JMSReconnectCallback jmsReconnectCallback) {
        this.jmsReconnectCallback = jmsReconnectCallback;
    }

    @Override
    public void onException(JMSException exception) {
        if (null != this.jmsReconnectCallback) {
            try {
                this.jmsReconnectCallback.onConnectionLost();
                this.scheduleReconnectCycle();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private void attemptReconnect() {
        if (null != this.jmsReconnectCallback) {
            try {
                this.jmsReconnectCallback.tryReconnecting();
                this.reconnectDelay = 1L;
            }
            catch (Exception e) {
                if (e instanceof JMSException || e.getCause() instanceof JMSException) {
                    this.reconnectDelay = Math.min(this.reconnectDelay * 2L, 128L);
                    this.scheduleReconnectCycle();
                }
                logger.error(e.getMessage(), e);
            }
        }
    }

    private void scheduleReconnectCycle() {
        logger.info("{} Scheduling reconnect timer, delay {} seconds", (Object)this.jmsReconnectCallback.ownerName(), (Object)this.reconnectDelay);
        reconnectTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                AutoReconnectAdapter.this.attemptReconnect();
            }
        }, this.reconnectDelay * 1000L);
    }
}

