/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

abstract class BaseSender {
    protected abstract MessageProducer makeSender(Session var1, String var2) throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doSend(Connection connection, String channel, Iterable<String> messages) throws JMSException {
        connection.start();
        Session session = connection.createSession(false, 1);
        MessageProducer producer = null;
        try {
            producer = this.makeSender(session, channel);
            for (String text : messages) {
                TextMessage message = session.createTextMessage(text);
                producer.send(message);
            }
        }
        finally {
            if (null != producer) {
                producer.close();
            }
            session.close();
        }
    }

    static class ProducerSender
    extends BaseSender {
        @Override
        protected MessageProducer makeSender(Session session, String name) throws JMSException {
            return session.createProducer(session.createQueue(name));
        }
    }

    static class PublishSender
    extends BaseSender {
        @Override
        protected MessageProducer makeSender(Session session, String name) throws JMSException {
            return session.createProducer(session.createTopic(name));
        }
    }
}

