/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.jms.JmsConstants;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

class ExceptionListenerContainer
implements ExceptionListener,
JmsConstants {
    private static final ExecutorService executor = MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("QpidJMS-ExceptionListener-%d").build()));
    private final CopyOnWriteArraySet<ExceptionListener> listeners = new CopyOnWriteArraySet();

    ExceptionListenerContainer(ExceptionListener listener) {
        this.merge(listener);
    }

    @Override
    public void onException(final JMSException exception) {
        for (final ExceptionListener listener : this.listeners) {
            if (null == listener) continue;
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    listener.onException(exception);
                }
            });
        }
    }

    private ExceptionListenerContainer merge(ExceptionListener listener) {
        if (listener instanceof ExceptionListenerContainer) {
            ExceptionListenerContainer container = (ExceptionListenerContainer)listener;
            this.listeners.addAll(container.listeners);
        } else if (null != listener) {
            this.listeners.add(listener);
        }
        return this;
    }

    void bind(Connection connection) {
        if (null != connection) {
            try {
                ExceptionListener old = connection.getExceptionListener();
                if (old instanceof ExceptionListenerContainer) {
                    ((ExceptionListenerContainer)old).merge(this);
                } else {
                    connection.setExceptionListener(this.merge(old));
                }
            }
            catch (JMSException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

