/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import gu.simplemq.Constant;
import gu.simplemq.jms.AdvisoryMessageManager;
import gu.simplemq.jms.JmsConsumer;
import gu.simplemq.jms.JmsPoolLazy;
import gu.simplemq.jms.JmsPoolLazys;
import gu.simplemq.jms.JmsProducer;
import gu.simplemq.jms.JmsPublisher;
import gu.simplemq.jms.JmsSubscriber;
import gu.simplemq.pool.BaseMQInstance;

public class JmsFactory
implements Constant {
    private final JmsPoolLazys jmsPoolLazys;
    private final BaseMQInstance<JmsConsumer, JmsPoolLazy> CONSUMERS = new BaseMQInstance<JmsConsumer, JmsPoolLazy>(){

        @Override
        protected void beforeDelete(JmsConsumer r) {
            try {
                r.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    };
    private final BaseMQInstance<JmsSubscriber, JmsPoolLazy> SUBSCRIBERS = new BaseMQInstance<JmsSubscriber, JmsPoolLazy>(){

        @Override
        protected void beforeDelete(JmsSubscriber r) {
            try {
                r.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    };
    private final BaseMQInstance<JmsProducer, JmsPoolLazy> PRODUCERS = new BaseMQInstance<JmsProducer, JmsPoolLazy>(){

        @Override
        protected void beforeDelete(JmsProducer r) {
            r.close();
        }
    };
    private final BaseMQInstance<JmsPublisher, JmsPoolLazy> PUBLISHERS = new BaseMQInstance<JmsPublisher, JmsPoolLazy>(){

        @Override
        protected void beforeDelete(JmsPublisher r) {
            r.close();
        }
    };

    public JmsFactory(JmsPoolLazys jmsPoolLazys) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    AdvisoryMessageManager.closeAll();
                    JmsFactory.this.closeAll();
                    JmsFactory.this.jmsPoolLazys.closeAll();
                }
                catch (Throwable e) {
                    Constant.logger.error(e.toString());
                }
            }
        });
        this.jmsPoolLazys = jmsPoolLazys;
    }

    public JmsConsumer getConsumer(JmsPoolLazy jedisPoolLazy) {
        return this.CONSUMERS.getInstance(jedisPoolLazy);
    }

    public JmsConsumer getConsumer() {
        return this.CONSUMERS.getInstance(this.jmsPoolLazys.getDefaultInstance());
    }

    public JmsSubscriber getSubscriber(JmsPoolLazy jedisPoolLazy) {
        return this.SUBSCRIBERS.getInstance(jedisPoolLazy);
    }

    public JmsSubscriber getSubscriber() {
        return this.SUBSCRIBERS.getInstance(this.jmsPoolLazys.getDefaultInstance());
    }

    public JmsProducer getProducer(JmsPoolLazy jedisPoolLazy) {
        return this.PRODUCERS.getInstance(jedisPoolLazy);
    }

    public JmsProducer getProducer() {
        return this.PRODUCERS.getInstance(this.jmsPoolLazys.getDefaultInstance());
    }

    public JmsPublisher getPublisher(JmsPoolLazy jedisPoolLazy) {
        return this.PUBLISHERS.getInstance(jedisPoolLazy);
    }

    public JmsPublisher getPublisher() {
        return this.PUBLISHERS.getInstance(this.jmsPoolLazys.getDefaultInstance());
    }

    public synchronized void closeAll() {
        this.CONSUMERS.clearInstances();
        this.SUBSCRIBERS.clearInstances();
        this.PUBLISHERS.clearInstances();
        this.PRODUCERS.clearInstances();
    }
}

