/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import gu.simplemq.jms.JmsConstants;
import gu.simplemq.jms.JmsPoolLazys;
import gu.simplemq.jms.JmsRuntimeContext;
import gu.simplemq.pool.BaseMQPool;
import gu.simplemq.utils.IntrospectionSupport;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.jms.pool.PooledConnectionFactory;

public class JmsPoolLazy
extends BaseMQPool<Connection>
implements JmsConstants {
    private final Properties parameters;
    private volatile PooledConnectionFactory pool;
    private final URI location;
    private String username;
    private String password;
    final JmsPoolLazys jmsPoolLazys;
    final JmsRuntimeContext runtimeContext;

    protected JmsPoolLazy(Map props, JmsPoolLazys jmsPoolLazys) {
        this.jmsPoolLazys = jmsPoolLazys;
        this.runtimeContext = jmsPoolLazys.runtimeContext;
        this.parameters = this.runtimeContext.getPropertiesHelper().initParameters(props);
        this.location = this.runtimeContext.getPropertiesHelper().getLocationlURI(props);
        jmsPoolLazys.POOLS.put(this.location, this);
        IntrospectionSupport.setProperties((Object)this, props, false);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public JmsPoolLazy asDefaultInstance() {
        this.jmsPoolLazys.setDefaultInstance(this);
        return this;
    }

    private PooledConnectionFactory createPool() {
        PooledConnectionFactory pool = this.runtimeContext.createPooledConnectionFactory(this.parameters);
        logger.info("jms pool initialized(\u8fde\u63a5\u6c60\u521d\u59cb\u5316)  {} ", (Object)this.getCanonicalURI());
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection borrow() {
        if (null == this.pool) {
            JmsPoolLazy jmsPoolLazy = this;
            synchronized (jmsPoolLazy) {
                if (null == this.pool) {
                    this.pool = this.createPool();
                }
            }
        }
        try {
            return this.pool.createConnection(this.username, this.password);
        }
        catch (JMSException e) {
            throw new BaseMQPool.MQPoolException(e);
        }
    }

    @Override
    public void release(Connection r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public URI getCanonicalURI() {
        return this.runtimeContext.getPropertiesHelper().getLocationlURI(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.pool != null) {
            JmsPoolLazy jmsPoolLazy = this;
            synchronized (jmsPoolLazy) {
                if (this.pool != null) {
                    this.pool.stop();
                    this.jmsPoolLazys.POOLS.remove(this.location);
                    logger.info("discard jms pool: {}", (Object)this);
                    this.pool = null;
                    this.closed = true;
                }
            }
        }
    }
}

