/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import gu.simplemq.Constant;
import gu.simplemq.jms.JmsPoolLazy;
import gu.simplemq.jms.JmsRuntimeContext;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;

public class JmsPoolLazys
implements Constant {
    final JmsRuntimeContext runtimeContext;
    final ConcurrentMap<URI, JmsPoolLazy> POOLS = Maps.newConcurrentMap();
    private volatile JmsPoolLazy defaultInstance;

    public JmsPoolLazys(JmsRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public JmsPoolLazy getDefaultInstance() {
        return null == this.defaultInstance ? this.createDefaultInstance(null) : this.defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean setDefaultInstance(JmsPoolLazy poolLazy) {
        if (null == this.defaultInstance) {
            Class<JmsPoolLazys> clazz = JmsPoolLazys.class;
            // MONITORENTER : gu.simplemq.jms.JmsPoolLazys.class
            if (null == this.defaultInstance && null != poolLazy) {
                this.defaultInstance = poolLazy;
                // MONITOREXIT : clazz
                return true;
            }
            // MONITOREXIT : clazz
        }
        logger.warn("INVALID INVOCATION,default instance was initialized already before this invocation");
        return false;
    }

    public boolean defaultInstanceInitialized() {
        return this.defaultInstance != null;
    }

    public final JmsPoolLazy createDefaultInstance(Properties props) {
        this.setDefaultInstance(this.getInstance(props));
        return this.defaultInstance;
    }

    JmsPoolLazy createInstance(Map props) {
        return new JmsPoolLazy(props, this);
    }

    public synchronized JmsPoolLazy getInstance(Properties props) {
        URI location = this.runtimeContext.getPropertiesHelper().getLocationlURI(props);
        JmsPoolLazy found = (JmsPoolLazy)this.POOLS.get(location);
        return found == null ? this.createInstance(props) : found;
    }

    public JmsPoolLazy getInstance(URI uri) {
        Properties props = new Properties();
        props.setProperty("uri", Preconditions.checkNotNull(uri, "uri is null").toString());
        return this.getInstance(props);
    }

    public JmsPoolLazy getInstanceByURI(String uri) {
        return this.getInstance(URI.create(uri));
    }

    public synchronized void closeAll() {
        Iterator itor = this.POOLS.values().iterator();
        while (itor.hasNext()) {
            JmsPoolLazy p = (JmsPoolLazy)itor.next();
            itor.remove();
            p.close();
        }
    }
}

