/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import com.google.common.net.HostAndPort;
import gu.simplemq.BaseMessageQueueFactory;
import gu.simplemq.IConsumer;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.IProducer;
import gu.simplemq.IPublisher;
import gu.simplemq.ISubscriber;
import gu.simplemq.MQLocationType;
import gu.simplemq.MQProperties;
import gu.simplemq.MQPropertiesHelper;
import gu.simplemq.MessageQueueType;
import gu.simplemq.jms.JmsConstants;
import gu.simplemq.jms.JmsFactory;
import gu.simplemq.jms.JmsPoolLazy;
import gu.simplemq.jms.JmsPoolLazys;
import gu.simplemq.jms.JmsRuntimeContext;
import gu.simplemq.mqtt.MqttConstants;
import gu.simplemq.mqtt.PropertiesHelper;
import gu.simplemq.utils.URISupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class MessageQueueFactoryImpl
extends BaseMessageQueueFactory<JmsPoolLazy>
implements JmsConstants,
MqttConstants {
    private volatile MQProperties props;
    private IMessageQueueFactory mqttFactory;
    private final JmsPoolLazys JmsPoolLazys;
    private final JmsFactory jmsFactory;
    protected final MQPropertiesHelper propertiesHelper;

    public MessageQueueFactoryImpl(JmsRuntimeContext runtimeContext) {
        this.JmsPoolLazys = new JmsPoolLazys(runtimeContext);
        this.jmsFactory = new JmsFactory(this.JmsPoolLazys);
        this.propertiesHelper = runtimeContext.getPropertiesHelper();
    }

    @Override
    protected void doInit(Map<String, Object> properties) {
        URI uri;
        this.mqConnParams = properties;
        this.props = this.propertiesHelper.with(MQLocationType.QUEUE).initParameters(properties);
        this.pool = this.JmsPoolLazys.createInstance(properties);
        String pubsub = this.propertiesHelper.with(MQLocationType.PUBSUB).getLocationAsString(properties);
        if (pubsub != null && "mqtt".equals((uri = URI.create(pubsub)).getScheme())) {
            try {
                uri = URISupport.changeScheme(uri, "tcp");
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            MQProperties p = PropertiesHelper.MHELPER.initParameters(properties).initURI(uri);
            this.mqttFactory = new gu.simplemq.mqtt.MessageQueueFactoryImpl().init((Map)p);
        }
    }

    @Override
    protected HostAndPort doGetHostAndPort() {
        return this.propertiesHelper.with(MQLocationType.QUEUE).getHostAndPort(this.props);
    }

    @Override
    public ISubscriber getSubscriber() {
        if (this.mqttFactory != null) {
            return this.mqttFactory.getSubscriber();
        }
        return this.jmsFactory.getSubscriber((JmsPoolLazy)this.getPool());
    }

    @Override
    public IPublisher getPublisher() {
        if (this.mqttFactory != null) {
            return this.mqttFactory.getPublisher();
        }
        return this.jmsFactory.getPublisher((JmsPoolLazy)this.getPool());
    }

    @Override
    public IProducer getProducer() {
        return this.jmsFactory.getProducer((JmsPoolLazy)this.getPool());
    }

    @Override
    public IConsumer getConsumer() {
        return this.jmsFactory.getConsumer((JmsPoolLazy)this.getPool());
    }

    @Override
    public final MessageQueueType getImplType() {
        return MessageQueueType.ACTIVEMQ;
    }

    @Override
    public boolean testConnect() {
        return this.propertiesHelper.testConnect(this.props, null);
    }

    @Override
    public void close() throws IOException {
        if (this.mqttFactory != null) {
            ((gu.simplemq.mqtt.MessageQueueFactoryImpl)this.mqttFactory).close();
        }
        super.close();
    }
}

