/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.jms;

import gu.simplemq.MQProperties;
import gu.simplemq.MQPropertiesHelper;
import gu.simplemq.jms.JmsConstants;
import gu.simplemq.jms.JmsRuntimeContext;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.apache.activemq.jms.pool.PooledConnectionFactory;

public abstract class PropertiesHelper
extends MQPropertiesHelper
implements JmsConstants {
    private final JmsRuntimeContext runtimeContext;

    public PropertiesHelper(JmsRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkConnect(Properties input, Integer timeoutMills) throws JMSException {
        MQProperties props = this.initParameters(input);
        String connectTimeout = this.getConstProvider().getMainConnectTimeout();
        if (timeoutMills != null && timeoutMills > 0 && connectTimeout != null) {
            props.setProperty(connectTimeout, timeoutMills.toString());
        }
        PooledConnectionFactory facetory = this.runtimeContext.createPooledConnectionFactory(props);
        try {
            Connection connect = facetory.createConnection();
            connect.createSession(Boolean.FALSE, 1);
        }
        finally {
            facetory.stop();
        }
    }

    @Override
    public boolean testConnect(Properties props, Integer timeoutMills) {
        try {
            this.checkConnect(props, timeoutMills);
            return true;
        }
        catch (JMSException je) {
            return false;
        }
    }
}

