/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.json;

import gu.simplemq.SimpleLog;
import gu.simplemq.exceptions.SmqNotBeanException;
import gu.simplemq.json.FastJsonInitializer;
import gu.simplemq.json.FastjsonEncoder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public abstract class BaseJsonEncoder {
    public abstract String toJsonString(Object var1);

    public abstract Map<String, String> toJsonMap(Object var1) throws SmqNotBeanException;

    public abstract <T> T fromJson(String var1, Type var2);

    public abstract <T> T fromJson(Map<String, String> var1, Type var2) throws SmqNotBeanException;

    public <T> T fromJson(String json, Class<T> clazz) {
        return this.fromJson(json, (Type)clazz);
    }

    public <T> T fromJson(Map<String, String> fieldHash, Class<T> clazz) throws SmqNotBeanException {
        return this.fromJson(fieldHash, (Type)clazz);
    }

    public Map<String, Object> fromJson(Map<String, String> fieldHash, Map<String, Type> types) {
        if (null == fieldHash) {
            return null;
        }
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, String> entry : fieldHash.entrySet()) {
            String field = entry.getKey();
            fields.put(field, this.fromJson(entry.getValue(), null == types ? null : types.get(field)));
        }
        return fields;
    }

    public <T> List<Object> toJsonArray(T ... array) {
        return null == array ? null : this.toJsonArray((Collection<?>)Arrays.asList(array));
    }

    public List<Object> toJsonArray(Collection<?> c) {
        if (null == c) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(16);
        for (Object element : c) {
            try {
                list.add(this.toJsonMap(element));
            }
            catch (SmqNotBeanException e) {
                list.add(this.toJsonString(element));
            }
        }
        return list;
    }

    public static final BaseJsonEncoder getEncoder() {
        return FastjsonEncoder.getInstance();
    }

    static {
        ServiceLoader<FastJsonInitializer> loader = ServiceLoader.load(FastJsonInitializer.class);
        Iterator<FastJsonInitializer> itor = loader.iterator();
        while (itor.hasNext()) {
            try {
                FastJsonInitializer initializer = itor.next();
                SimpleLog.log("FastJsonInitializer: " + initializer.getClass().getName(), new Object[0]);
                initializer.init();
            }
            catch (Exception e) {
                SimpleLog.log(e);
            }
        }
    }
}

