/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.mqtt;

import gu.simplemq.Constant;
import gu.simplemq.mqtt.MqttPoolLazy;
import gu.simplemq.mqtt.MqttPoolLazys;
import gu.simplemq.mqtt.MqttPublisher;
import gu.simplemq.mqtt.MqttSubscriber;
import gu.simplemq.pool.BaseMQInstance;

public class MqttFactory
implements Constant {
    private static final BaseMQInstance<MqttSubscriber, MqttPoolLazy> SUBSCRIBERS = new BaseMQInstance<MqttSubscriber, MqttPoolLazy>(){

        @Override
        protected void beforeDelete(MqttSubscriber r) {
            try {
                r.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    };
    private static final BaseMQInstance<MqttPublisher, MqttPoolLazy> PUBLISHERS = new BaseMQInstance<MqttPublisher, MqttPoolLazy>(){};

    private MqttFactory() {
    }

    public static MqttSubscriber getSubscriber(MqttPoolLazy poolLazy) {
        return SUBSCRIBERS.getInstance(poolLazy);
    }

    public static MqttSubscriber getSubscriber() {
        return SUBSCRIBERS.getInstance(MqttPoolLazys.getDefaultInstance());
    }

    public static MqttPublisher getPublisher(MqttPoolLazy poolLazy) {
        return PUBLISHERS.getInstance(poolLazy);
    }

    public static MqttPublisher getPublisher() {
        return PUBLISHERS.getInstance(MqttPoolLazys.getDefaultInstance());
    }

    public static synchronized void closeAll() {
        SUBSCRIBERS.clearInstances();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    MqttFactory.closeAll();
                    MqttPoolLazys.closeAll();
                }
                catch (Throwable e) {
                    Constant.logger.error(e.toString());
                }
            }
        });
    }
}

