/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.mqtt;

import com.google.common.base.Strings;
import gu.simplemq.mqtt.MqttConstants;
import gu.simplemq.mqtt.MqttPoolLazys;
import gu.simplemq.mqtt.PropertiesHelper;
import gu.simplemq.pool.BaseMQPool;
import gu.simplemq.utils.IntrospectionSupport;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttPoolLazy
extends BaseMQPool<MqttClient>
implements MqttConstants {
    private final Properties parameters;
    private String serverURI;
    private String clientId;
    private int qos = 2;
    private final MqttConnectOptions connOpts = new MqttConnectOptions();
    private volatile MqttClient mqttClient;
    private final URI location;

    protected MqttPoolLazy(Properties props) {
        this.parameters = PropertiesHelper.MHELPER.initParameters(props);
        this.location = PropertiesHelper.MHELPER.getLocationlURI(props);
        MqttPoolLazys.POOLS.put(this.location, this);
        IntrospectionSupport.setProperties((Object)this, (Map)this.parameters, false);
        IntrospectionSupport.setProperties((Object)this.connOpts, (Map)this.parameters, "connOpts.");
        this.connOpts.setAutomaticReconnect(true);
    }

    public MqttPoolLazy setServerURI(String serverURI) {
        this.serverURI = serverURI;
        return this;
    }

    public MqttPoolLazy setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public int getQos() {
        return this.qos;
    }

    public void setQos(int qos) {
        this.qos = qos;
    }

    public Properties getParameters() {
        return new Properties(this.parameters);
    }

    public MqttPoolLazy asDefaultInstance() {
        MqttPoolLazys.setDefaultInstance(this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttClient borrow() throws BaseMQPool.MQPoolException {
        if (this.mqttClient == null) {
            MqttPoolLazy mqttPoolLazy = this;
            synchronized (mqttPoolLazy) {
                if (this.mqttClient == null) {
                    try {
                        this.mqttClient = new MqttClient(this.serverURI, Strings.isNullOrEmpty(this.clientId) ? MqttClient.generateClientId() : this.clientId, null);
                        this.mqttClient.connect(this.connOpts);
                        logger.info("mqtt client initialized(MQTT\u5ba2\u6237\u7aef\u521d\u59cb\u5316)  {} ", (Object)this.getCanonicalURI());
                    }
                    catch (MqttException e) {
                        throw new BaseMQPool.MQPoolException(e);
                    }
                }
            }
        }
        return this.mqttClient;
    }

    @Override
    public void release(MqttClient r) {
    }

    @Override
    public URI getCanonicalURI() {
        return PropertiesHelper.MHELPER.getLocationlURI(this.parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.mqttClient != null) {
            MqttPoolLazy mqttPoolLazy = this;
            synchronized (mqttPoolLazy) {
                if (this.mqttClient != null) {
                    try {
                        if (this.mqttClient.isConnected()) {
                            this.mqttClient.disconnect();
                        }
                        this.mqttClient.close();
                        MqttPoolLazys.POOLS.remove(this.location);
                        logger.info("discard mqtt client: {}", (Object)this);
                        this.mqttClient = null;
                        this.closed = true;
                    }
                    catch (MqttException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

