/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.mqtt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import gu.simplemq.mqtt.MqttConstants;
import gu.simplemq.mqtt.MqttPoolLazy;
import gu.simplemq.mqtt.PropertiesHelper;
import java.net.URI;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;

public class MqttPoolLazys
implements MqttConstants {
    static final Properties DEFAULT_PARAMETERS = new Properties(){
        {
            this.put("serverURI", "tcp://localhost:1883");
            this.put("connOpts.automaticReconnect", (Object)true);
        }
    };
    static final ConcurrentMap<URI, MqttPoolLazy> POOLS = Maps.newConcurrentMap();
    private static volatile MqttPoolLazy defaultInstance;

    public static MqttPoolLazy getDefaultInstance() {
        return null == defaultInstance ? MqttPoolLazys.createDefaultInstance(null) : defaultInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean setDefaultInstance(MqttPoolLazy poolLazy) {
        if (null == defaultInstance) {
            Class<MqttPoolLazys> clazz = MqttPoolLazys.class;
            // MONITORENTER : gu.simplemq.mqtt.MqttPoolLazys.class
            if (null == defaultInstance && null != poolLazy) {
                defaultInstance = poolLazy;
                // MONITOREXIT : clazz
                return true;
            }
            // MONITOREXIT : clazz
        }
        logger.warn("INVALID INVOCATION,default instance was initialized already before this invocation");
        return false;
    }

    public static boolean defaultInstanceInitialized() {
        return defaultInstance != null;
    }

    public static final MqttPoolLazy createDefaultInstance(Properties props) {
        MqttPoolLazys.setDefaultInstance(MqttPoolLazys.getInstance(props));
        return defaultInstance;
    }

    static MqttPoolLazy createInstance(Properties props) {
        return new MqttPoolLazy(props);
    }

    public static synchronized MqttPoolLazy getInstance(Properties props) {
        URI location = PropertiesHelper.MHELPER.getLocationlURI(props);
        MqttPoolLazy found = (MqttPoolLazy)POOLS.get(location);
        return found == null ? MqttPoolLazys.createInstance(props) : found;
    }

    public static MqttPoolLazy getInstance(URI uri) {
        Properties props = new Properties();
        props.setProperty("serverURI", Preconditions.checkNotNull(uri, "uri is null").toString());
        return MqttPoolLazys.getInstance(props);
    }

    public static MqttPoolLazy getInstanceByURI(String uri) {
        return MqttPoolLazys.getInstance(URI.create(uri));
    }

    public static synchronized void closeAll() {
        Iterator itor = POOLS.values().iterator();
        while (itor.hasNext()) {
            MqttPoolLazy p = (MqttPoolLazy)itor.next();
            itor.remove();
            p.close();
        }
    }
}

