/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.mqtt;

import gu.simplemq.BaseMQPublisher;
import gu.simplemq.Constant;
import gu.simplemq.IAdvisor;
import gu.simplemq.MQConnectionException;
import gu.simplemq.MQRuntimeException;
import gu.simplemq.ZeroAdvisor;
import gu.simplemq.mqtt.MqttPoolLazy;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;

public class MqttPublisher
extends BaseMQPublisher<MqttClient>
implements Constant {
    private final int qos;
    private final IAdvisor adivsor = new ZeroAdvisor();

    public MqttPublisher(MqttPoolLazy poolLazy) {
        super(poolLazy);
        this.qos = poolLazy.getQos();
    }

    @Override
    protected void doSend(MqttClient c, String channel, Iterable<String> messages) throws Exception {
        for (String message : messages) {
            try {
                c.publish(channel, message.getBytes(UTF_8), this.qos, false);
            }
            catch (MqttException e) {
                if (e.getReasonCode() == 32104) {
                    throw new MQConnectionException(e);
                }
                throw new MQRuntimeException(e);
            }
            catch (Throwable e) {
                throw new MQRuntimeException(e);
            }
        }
    }

    @Override
    public IAdvisor getAdvisor() {
        return this.adivsor;
    }
}

