/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.mqtt;

import gu.simplemq.BaseMQDispatcher;
import gu.simplemq.mqtt.MqttPoolLazy;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttMessage;

class MqttSubscriber
extends BaseMQDispatcher<MqttClient>
implements MqttCallbackExtended {
    private final int qos;

    MqttSubscriber(MqttPoolLazy pool) {
        super(pool);
        this.qos = pool.getQos();
    }

    @Override
    protected void doInit() throws Exception {
        ((MqttClient)this.getConnection()).setCallback(this);
    }

    @Override
    protected void doSub(String channel) throws Exception {
        ((MqttClient)this.getConnection()).subscribe(channel, this.qos);
    }

    @Override
    protected void doUnsub(String channel) throws Exception {
        if (((MqttClient)this.getConnection()).isConnected()) {
            ((MqttClient)this.getConnection()).unsubscribe(channel);
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String text = new String(message.getPayload(), UTF_8);
        this.dispatch(topic, text);
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    @Override
    public void connectComplete(boolean reconnect, String serverURI) {
        if (reconnect) {
            this.subscribe(this.allRegisteredChannels().keySet().toArray(new String[0]));
        }
    }
}

