/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.proton;

import gu.simplemq.utils.IntrospectionSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import org.apache.activemq.jms.pool.ConnectionPool;
import org.apache.activemq.jms.pool.PooledConnection;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PooledConnectionFactory
extends org.apache.activemq.jms.pool.PooledConnectionFactory {
    public static final String POOL_PROPS_PREFIX = "pool";
    private static final transient Logger LOG = LoggerFactory.getLogger(org.apache.activemq.jms.pool.PooledConnectionFactory.class);

    public PooledConnectionFactory() {
    }

    public PooledConnectionFactory(JmsConnectionFactory jmsConnectionFactory) {
        this.setConnectionFactory(jmsConnectionFactory);
    }

    public PooledConnectionFactory(String brokerURL) {
        this.setConnectionFactory(new JmsConnectionFactory(brokerURL));
    }

    protected void buildFromProperties(Properties props) {
        JmsConnectionFactory jmsConnectionFactory = new JmsConnectionFactory();
        jmsConnectionFactory.setProperties(props);
        this.setConnectionFactory(jmsConnectionFactory);
        IntrospectionSupport.setProperties((Object)this, new HashMap<Object, Object>(props), POOL_PROPS_PREFIX);
    }

    @Override
    protected void populateProperties(Properties props) {
        Map<String, String> result = ((JmsConnectionFactory)this.getConnectionFactory()).getProperties();
        props.putAll(result);
        super.populateProperties(props);
    }

    public void setProperties(Properties properties) {
        this.buildFromProperties(properties);
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        this.populateProperties(properties);
        return properties;
    }

    @Override
    protected Connection newPooledConnection(ConnectionPool connection) {
        return new PooledConnection(connection);
    }

    @Override
    protected ConnectionPool createConnectionPool(Connection connection) {
        return new ConnectionPool(connection){

            @Override
            protected Connection wrap(final Connection connection) {
                try {
                    ((JmsConnection)connection).setExceptionListener(new ExceptionListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onException(JMSException error) {
                            1 var2_2 = this;
                            synchronized (var2_2) {
                                this.setHasExpired(true);
                                if (!PooledConnectionFactory.this.stopped.get()) {
                                    LOG.info("Expiring connection " + connection + " on IOException: " + error.getMessage());
                                    LOG.debug("Expiring connection " + connection + " on IOException: ", error);
                                }
                            }
                        }
                    });
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
                this.setHasExpired(((JmsConnection)connection).isFailed());
                return connection;
            }

            @Override
            protected void unWrap(Connection connection) {
                if (connection != null) {
                    IntrospectionSupport.getProperty((JmsConnection)connection, "tempDestinations", Map.class).clear();
                }
            }
        };
    }
}

