/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.proton;

import gu.simplemq.BaseMQContext;
import gu.simplemq.IMessageQueueFactory;
import gu.simplemq.MQPropertiesHelper;
import gu.simplemq.MessageQueueType;
import gu.simplemq.jms.JmsRuntimeContext;
import gu.simplemq.jms.MessageQueueFactoryImpl;
import gu.simplemq.proton.PooledConnectionFactory;
import gu.simplemq.proton.ProtonPropertiesHelper;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.qpid.jms.JmsDestination;
import org.apache.qpid.jms.message.JmsMessage;

class ProtonRuntimeContext
extends BaseMQContext
implements JmsRuntimeContext {
    static final ProtonRuntimeContext PROTON_CONTEXT = new ProtonRuntimeContext();
    private final ProtonPropertiesHelper protonHelper = new ProtonPropertiesHelper(this);
    private final MessageQueueFactoryImpl factory = new MessageQueueFactoryImpl(this);

    public ProtonRuntimeContext() {
        super(MessageQueueType.ACTIVEMQ, "AMQP");
    }

    @Override
    public MQPropertiesHelper getPropertiesHelper() {
        return this.protonHelper;
    }

    @Override
    public IMessageQueueFactory getMessageQueueFactory() {
        return this.factory;
    }

    @Override
    public PooledConnectionFactory createPooledConnectionFactory(Properties properties) {
        PooledConnectionFactory pool = new PooledConnectionFactory();
        pool.setProperties(properties);
        return pool;
    }

    @Override
    public String destNameOf(Message message) throws JMSException {
        JmsMessage jmsMessage = (JmsMessage)message;
        JmsDestination dest = (JmsDestination)jmsMessage.getJMSDestination();
        return dest.getName();
    }
}

