/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.MoreObjects;
import com.google.common.net.HostAndPort;
import gu.simplemq.BaseMessageQueueFactory;
import gu.simplemq.IConsumer;
import gu.simplemq.IProducer;
import gu.simplemq.IPublisher;
import gu.simplemq.ISubscriber;
import gu.simplemq.MessageQueueType;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.JedisUtils;
import gu.simplemq.redis.RedisFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MessageQueueFactoryImpl
extends BaseMessageQueueFactory<JedisPoolLazy> {
    private HashMap<JedisPoolLazy.PropName, Object> props;

    @Override
    protected void doInit(Map<String, Object> properties) {
        this.mqConnParams = properties;
        this.props = JedisUtils.initAsRedisParameters(MoreObjects.firstNonNull(properties, Collections.emptyMap()));
        this.pool = JedisPoolLazy.createInstance(this.props);
    }

    @Override
    protected HostAndPort doGetHostAndPort() {
        return JedisUtils.getHostAndPort(this.props);
    }

    @Override
    public ISubscriber getSubscriber() {
        return RedisFactory.getSubscriber((JedisPoolLazy)this.getPool());
    }

    @Override
    public IPublisher getPublisher() {
        return RedisFactory.getPublisher((JedisPoolLazy)this.getPool());
    }

    @Override
    public IProducer getProducer() {
        return RedisFactory.getProducer((JedisPoolLazy)this.getPool());
    }

    @Override
    public IConsumer getConsumer() {
        return RedisFactory.getConsumer((JedisPoolLazy)this.getPool());
    }

    @Override
    public final MessageQueueType getImplType() {
        return MessageQueueType.REDIS;
    }

    @Override
    public boolean testConnect() {
        return JedisUtils.testConnect(this.props);
    }
}

