/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import gu.simplemq.exceptions.SmqTypeException;
import gu.simplemq.redis.JedisPoolLazy;
import redis.clients.jedis.Jedis;

enum RedisComponentType {
    Table,
    Queue,
    Channel;


    public String check(JedisPoolLazy poolLazy, String name) throws SmqTypeException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "name must not be null or empty");
        Jedis jedis = (Jedis)poolLazy.apply();
        try {
            if (!jedis.exists(name).booleanValue()) {
                String string = name;
                return string;
            }
            switch (this) {
                case Table: {
                    break;
                }
                case Queue: {
                    if (RedisKeyType.valueOf(jedis.type(name)) != RedisKeyType.list) break;
                    String string = name;
                    return string;
                }
            }
            throw new SmqTypeException(String.format("the '%s' can't be used for %s", name, this.name()));
        }
        finally {
            poolLazy.free();
        }
    }

    private static enum RedisKeyType {
        string,
        list,
        set,
        zset,
        none,
        hash;

    }
}

