/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import gu.simplemq.Channel;
import gu.simplemq.Constant;
import gu.simplemq.pool.BaseMQInstance;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisConsumer;
import gu.simplemq.redis.RedisProducer;
import gu.simplemq.redis.RedisPublisher;
import gu.simplemq.redis.RedisSubscriber;
import gu.simplemq.redis.RedisTable;
import java.lang.reflect.Type;

public class RedisFactory
implements Constant {
    private static final Table<JedisPoolLazy, String, RedisTable> TABLE = HashBasedTable.create();
    private static final BaseMQInstance<RedisConsumer, JedisPoolLazy> CONSUMERS = new BaseMQInstance<RedisConsumer, JedisPoolLazy>(){

        @Override
        protected void beforeDelete(RedisConsumer r) {
            r.close();
        }
    };
    private static final BaseMQInstance<RedisSubscriber, JedisPoolLazy> SUBSCRIBERS = new BaseMQInstance<RedisSubscriber, JedisPoolLazy>(){

        @Override
        protected void beforeDelete(RedisSubscriber r) {
            r.close();
        }
    };
    private static final BaseMQInstance<RedisProducer, JedisPoolLazy> PRODUCERS = new BaseMQInstance<RedisProducer, JedisPoolLazy>(){};
    private static final BaseMQInstance<RedisPublisher, JedisPoolLazy> PUBLISHERS = new BaseMQInstance<RedisPublisher, JedisPoolLazy>(){};

    private RedisFactory() {
    }

    public static <V> RedisTable<V> getTable(Class<V> clazz) {
        return RedisFactory.getTable(clazz, JedisPoolLazy.getDefaultInstance(), Preconditions.checkNotNull(clazz, "clazz is null").getSimpleName());
    }

    public static <V> RedisTable<V> getTable(Class<V> clazz, JedisPoolLazy pool, String tablename) {
        return RedisFactory.getTable(clazz, pool, tablename);
    }

    public static <V> RedisTable<V> getTable(Channel<V> channel, JedisPoolLazy pool) {
        return RedisFactory.getTable(channel.type, pool, channel.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> RedisTable<V> getTable(Type type, JedisPoolLazy pool, String tablename) {
        Preconditions.checkArgument(null != type && null != pool && null != tablename, "input aruments must not be null");
        if (!TABLE.contains(pool, tablename)) {
            Table<JedisPoolLazy, String, RedisTable> table = TABLE;
            synchronized (table) {
                if (!TABLE.contains(pool, tablename)) {
                    RedisTable redisTable = TABLE.put(pool, tablename, new RedisTable(type, pool, tablename));
                }
            }
        }
        RedisTable table = TABLE.get(pool, tablename);
        Preconditions.checkState(table.getType().equals(type), "mismatch type " + type + " vs " + table.getType());
        return table;
    }

    public static RedisConsumer getConsumer(JedisPoolLazy jedisPoolLazy) {
        return CONSUMERS.getInstance(jedisPoolLazy);
    }

    public static RedisConsumer getConsumer() {
        return CONSUMERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static RedisSubscriber getSubscriber(JedisPoolLazy jedisPoolLazy) {
        return SUBSCRIBERS.getInstance(jedisPoolLazy);
    }

    public static RedisSubscriber getSubscriber() {
        return SUBSCRIBERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static RedisProducer getProducer(JedisPoolLazy jedisPoolLazy) {
        return PRODUCERS.getInstance(jedisPoolLazy);
    }

    public static RedisProducer getProducer() {
        return PRODUCERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static RedisPublisher getPublisher(JedisPoolLazy jedisPoolLazy) {
        return PUBLISHERS.getInstance(jedisPoolLazy);
    }

    public static RedisPublisher getPublisher() {
        return PUBLISHERS.getInstance(JedisPoolLazy.getDefaultInstance());
    }

    public static synchronized void closeAll() {
        CONSUMERS.clearInstances();
        SUBSCRIBERS.clearInstances();
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Constant.logger.info("RedisFactory close all of consumers,subscribers");
                    RedisFactory.closeAll();
                }
                catch (Throwable e) {
                    Constant.logger.error(e.getMessage(), e);
                }
            }
        });
    }
}

