/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Function;
import gu.simplemq.Channel;
import gu.simplemq.IAdvisor;
import gu.simplemq.IPublisher;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisConstants;
import gu.simplemq.redis.RedisConsumerAdvisor;
import gu.simplemq.utils.CommonUtils;
import java.util.Collection;
import redis.clients.jedis.Jedis;

public class RedisPublisher
implements IPublisher,
IRedisComponent,
RedisConstants {
    private static final BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    private static final Function<Object, String> jsonFun = new Function<Object, String>(){

        @Override
        public String apply(Object input) {
            return encoder.toJsonString(input);
        }
    };
    private final JedisPoolLazy poolLazy;
    private final RedisConsumerAdvisor advisor;
    private Function<Object, String> stringSerializer = jsonFun;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.poolLazy;
    }

    public RedisPublisher(JedisPoolLazy poolLazy) {
        this.poolLazy = poolLazy;
        this.advisor = RedisConsumerAdvisor.topicAdvisorOf(poolLazy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long publish(Channel<T> channel, T obj) {
        if (null == obj) {
            return 0L;
        }
        if (null != channel.type && channel.type instanceof Class && !((Class)channel.type).isInstance(obj)) {
            throw new IllegalArgumentException("invalid type of 'obj'");
        }
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            Long numOfClient = jedis.publish(channel.name, this.stringSerializer.apply(obj));
            long l = null == numOfClient ? 0L : numOfClient;
            return l;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public <T> void publish(Channel<T> channel, Collection<T> objects) {
        objects = CommonUtils.cleanNullAsList(objects);
        for (T obj : objects) {
            this.publish(channel, obj);
        }
    }

    @Override
    public <T> void publish(Channel<T> channel, T ... objects) {
        this.publish(channel, (Collection<T>)CommonUtils.cleanNullAsList(objects));
    }

    @Override
    public IAdvisor getAdvisor() {
        return this.advisor;
    }

    @Override
    public IPublisher withStringSerializer(Function<Object, String> stringSerializer) {
        this.stringSerializer = null == stringSerializer ? jsonFun : stringSerializer;
        return this;
    }
}

