/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.base.Strings;
import gu.simplemq.json.BaseJsonEncoder;
import gu.simplemq.redis.IRedisQueue;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.RedisComponentType;
import gu.simplemq.utils.CommonUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import redis.clients.jedis.Jedis;

public class RedisQueue<E>
extends AbstractQueue<E>
implements IRedisQueue<E> {
    private final Type type;
    private BaseJsonEncoder encoder = BaseJsonEncoder.getEncoder();
    private String queueName;
    private final JedisPoolLazy poolLazy;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.poolLazy;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    public RedisQueue<E> setQueueName(String queueName) {
        if (!Strings.isNullOrEmpty(queueName)) {
            this.queueName = RedisComponentType.Queue.check(this.poolLazy, queueName);
        }
        return this;
    }

    public RedisQueue(Type type) {
        this(type, JedisPoolLazy.getDefaultInstance());
    }

    public RedisQueue(Type type, JedisPoolLazy poolLazy) {
        if (!(type instanceof Class) && !(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("invalid type of 'type' :must be Class<?> or ParameterizedType");
        }
        this.type = type;
        this.poolLazy = poolLazy;
        this.setQueueName(type.toString());
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean offer(E e) {
        return this.offerLast(e);
    }

    @Override
    public E poll() {
        return this.pollFirst();
    }

    @Override
    public E peek() {
        return this.peekFirst();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            int n = jedis.llen(this.queueName).intValue();
            return n;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public int remainingCapacity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E removeFirst() {
        E x = this.pollFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E removeLast() {
        E x = this.pollLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E pollFirst() {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            Object t = this.encoder.fromJson(jedis.lpop(this.queueName), this.getType());
            return (E)t;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public E pollLast() {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            Object t = this.encoder.fromJson(jedis.rpop(this.queueName), this.getType());
            return (E)t;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public E getFirst() {
        E x = this.peekFirst();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    @Override
    public E getLast() {
        E x = this.peekLast();
        if (x == null) {
            throw new NoSuchElementException();
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekFirst() {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            List<String> list = jedis.lrange(this.queueName, 0L, 0L);
            if (list.size() > 0) {
                Object t = this.encoder.fromJson(list.get(0), this.getType());
                return (E)t;
            }
            E e = null;
            return e;
        }
        finally {
            this.poolLazy.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E peekLast() {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            List<String> list = jedis.lrange(this.queueName, -1L, -1L);
            if (list.size() > 0) {
                Object t = this.encoder.fromJson(list.get(0), this.getType());
                return (E)t;
            }
            E e = null;
            return e;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFirst(E e) {
        this.offerFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.offerLast(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            jedis.lpush(this.queueName, this.encoder.toJsonString(e));
            boolean bl = true;
            return bl;
        }
        finally {
            this.poolLazy.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            jedis.rpush(this.queueName, this.encoder.toJsonString(e));
            boolean bl = true;
            return bl;
        }
        finally {
            this.poolLazy.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int offer(boolean offerLast, E ... array) {
        List<E> list = CommonUtils.cleanNullAsList(array);
        if (list.isEmpty()) {
            return 0;
        }
        String[] strings = new String[list.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.encoder.toJsonString(list.get(i));
        }
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            if (offerLast) {
                int n = jedis.rpush(this.queueName, strings).intValue();
                return n;
            }
            int n = jedis.lpush(this.queueName, strings).intValue();
            return n;
        }
        finally {
            this.poolLazy.free();
        }
    }

    public int offerFirst(E ... e) {
        return this.offer(false, e);
    }

    public int offerLast(E ... e) {
        return this.offer(true, e);
    }

    @Override
    public void putFirst(E e) throws InterruptedException {
        this.offerFirst(e);
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        this.offerLast(e);
    }

    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerFirst(e);
    }

    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            List<String> list = jedis.blpop(Integer.MAX_VALUE, this.queueName);
            Object t = this.encoder.fromJson(list.get(0), this.getType());
            return (E)t;
        }
        finally {
            this.poolLazy.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            List<String> list = jedis.brpop(Integer.MAX_VALUE, this.queueName);
            Object t = this.encoder.fromJson(list.get(0), this.getType());
            return (E)t;
        }
        finally {
            this.poolLazy.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            List<String> list = jedis.blpop((int)TimeUnit.SECONDS.convert(timeout, unit), this.queueName);
            if (list.isEmpty()) {
                E e = null;
                return e;
            }
            Object t = this.encoder.fromJson(list.get(1), this.getType());
            return (E)t;
        }
        finally {
            this.poolLazy.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        Jedis jedis = (Jedis)this.poolLazy.apply();
        try {
            List<String> list = jedis.brpop((int)TimeUnit.SECONDS.convert(timeout, unit), this.queueName);
            if (list.isEmpty()) {
                E e = null;
                return e;
            }
            Object t = this.encoder.fromJson(list.get(1), this.getType());
            return (E)t;
        }
        finally {
            this.poolLazy.free();
        }
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public BlockingQueue<E> getQueue() {
        return this;
    }
}

