/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.redis;

import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gu.simplemq.BaseSubscriber;
import gu.simplemq.Constant;
import gu.simplemq.IMessageDispatcher;
import gu.simplemq.exceptions.SmqTypeException;
import gu.simplemq.redis.IRedisComponent;
import gu.simplemq.redis.JedisPoolLazy;
import gu.simplemq.redis.JedisUtils;
import gu.simplemq.redis.RedisComponentType;
import gu.simplemq.redis.RedisSubHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisSubscriber
extends BaseSubscriber
implements IRedisComponent {
    private final JedisPoolLazy pool;
    private RedisSubHandle jedisPubSub;
    private final AtomicBoolean closed = new AtomicBoolean(Boolean.FALSE);
    private static final int RECONNECT_DELAY_MILLS = 5000;
    private static final ExecutorService subscribeExecutor = MoreExecutors.getExitingExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("stp-subscribe-%d").build()));
    private volatile Jedis jedis = null;
    private final String clientId;

    @Override
    public JedisPoolLazy getPoolLazy() {
        return this.pool;
    }

    RedisSubscriber(JedisPoolLazy poolLazy) {
        this.jedisPubSub = new RedisSubHandle(this);
        this.pool = poolLazy;
        this.clientId = "RedisSubscriber_" + JedisUtils.incr(poolLazy, "simplemq_subscriber_counter");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSubscribe(String ... channels) {
        RedisSubscriber redisSubscriber = this;
        synchronized (redisSubscriber) {
            try {
                this.jedisPubSub.subscribe(channels);
            }
            catch (JedisConnectionException e) {
                this.open(channels);
            }
            this.addSubscriber(channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doUnsubscribe(String ... channels) {
        RedisSubscriber redisSubscriber = this;
        synchronized (redisSubscriber) {
            if (this.jedisPubSub.isSubscribed()) {
                this.jedisPubSub.unsubscribe(channels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jedis getJedis() {
        if (null == this.jedis) {
            RedisSubscriber redisSubscriber = this;
            synchronized (redisSubscriber) {
                if (null == this.jedis) {
                    this.jedis = this.pool.borrow();
                }
            }
        }
        return this.jedis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseJedis() {
        if (this.jedis != null) {
            RedisSubscriber redisSubscriber = this;
            synchronized (redisSubscriber) {
                if (this.jedis != null) {
                    this.pool.release(this.jedis);
                    this.jedis = null;
                }
            }
        }
    }

    private void open(final String ... channels) {
        Runnable run = new Runnable(){
            String[] subs;
            {
                this.subs = channels;
            }

            @Override
            public void run() {
                while (!RedisSubscriber.this.closed.get()) {
                    try {
                        RedisSubscriber.this.getJedis().subscribe(RedisSubscriber.this.jedisPubSub, this.subs);
                        break;
                    }
                    catch (JedisConnectionException e) {
                        RedisSubscriber.this.releaseJedis();
                        if (!RedisSubscriber.this.closed.get()) {
                            Constant.logger.error("Subscribing failed. {}", (Object)e.getMessage());
                        }
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        this.subs = RedisSubscriber.this.channelSubs.keySet().toArray(new String[0]);
                    }
                    catch (Throwable e) {
                        if (RedisSubscriber.this.closed.get()) continue;
                        Constant.logger.error("Subscribing failed.", e);
                    }
                }
            }
        };
        subscribeExecutor.execute(run);
    }

    public RedisSubscriber setDispatcher(IMessageDispatcher dispatcher) {
        this.jedisPubSub.setDispatcher(dispatcher);
        return this;
    }

    @Override
    protected String check(String name) throws SmqTypeException {
        return RedisComponentType.Channel.check(this.pool, name);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(Boolean.FALSE, Boolean.TRUE)) {
            try {
                super.close();
                this.releaseJedis();
            }
            catch (JedisConnectionException e) {
                logger.error(e.toString());
            }
        }
    }

    private void addSubscriber(Collection<String> chSet) {
        for (String name : chSet) {
            JedisUtils.sadd(name + "_subscribers", this.clientId);
        }
    }

    private void addSubscriber(String[] chSet) {
        this.addSubscriber(Arrays.asList(chSet));
    }
}

