/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;

public interface ILazyInitVariable<T> {
    public T get();

    public static class Factory {
        public static final <T> ILazyInitVariable<T> makeInstance(Supplier<T> supplier) {
            return Factory.makeInstance(false, supplier);
        }

        public static final <T> ILazyInitVariable<T> makeInstance(boolean tls, Supplier<T> supplier) {
            return tls ? new TlsImpl<T>(supplier) : new VolatileImpl<T>(supplier);
        }

        private static class TlsImpl<T>
        implements ILazyInitVariable<T> {
            private final ThreadLocal perThreadInstance = new ThreadLocal();
            private T var = null;
            private final Supplier<T> supplier;

            public TlsImpl(Supplier<T> supplier) {
                this.supplier = Preconditions.checkNotNull(supplier);
            }

            @Override
            public T get() {
                if (null == this.perThreadInstance.get()) {
                    this.init();
                }
                return this.var;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void init() {
                TlsImpl tlsImpl = this;
                synchronized (tlsImpl) {
                    if (null == this.var) {
                        this.var = this.supplier.get();
                    }
                }
                this.perThreadInstance.set(this.perThreadInstance);
            }
        }

        private static class VolatileImpl<T>
        implements ILazyInitVariable<T> {
            private volatile T var = null;
            private final Supplier<T> supplier;

            public VolatileImpl(Supplier<T> supplier) {
                this.supplier = Preconditions.checkNotNull(supplier);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (null == this.var) {
                    VolatileImpl volatileImpl = this;
                    synchronized (volatileImpl) {
                        if (null == this.var) {
                            this.var = this.supplier.get();
                        }
                    }
                }
                return this.var;
            }
        }
    }
}

