/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.utils;

import gu.simplemq.utils.TypeConversionSupport;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLServerSocket;

public final class IntrospectionSupport {
    private IntrospectionSupport() {
    }

    public static boolean getProperties(Object target, Map props, String optionPrefix) {
        Method[] methods;
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        if (optionPrefix == null) {
            optionPrefix = "";
        }
        Class<?> clazz = target.getClass();
        for (Method method : methods = clazz.getMethods()) {
            String name = method.getName();
            Class<?> type = method.getReturnType();
            Class<?>[] params = method.getParameterTypes();
            if (!name.startsWith("is") && !name.startsWith("get") || params.length != 0 || type == null) continue;
            try {
                String strValue;
                Object value = method.invoke(target, new Object[0]);
                if (value == null || (strValue = TypeConversionSupport.convert(value, String.class)) == null) continue;
                name = name.startsWith("get") ? name.substring(3, 4).toLowerCase(Locale.ENGLISH) + name.substring(4) : name.substring(2, 3).toLowerCase(Locale.ENGLISH) + name.substring(3);
                props.put(optionPrefix + name, strValue);
                rc = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props, String optionPrefix) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            if (!IntrospectionSupport.setProperty(target, name = name.substring(optionPrefix.length()), value)) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static Map<String, Object> extractProperties(Map props, String optionPrefix) {
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        HashMap<String, Object> rc = new HashMap<String, Object>(props.size());
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!name.startsWith(optionPrefix)) continue;
            Object value = props.get(name);
            name = name.substring(optionPrefix.length());
            rc.put(name, value);
            iter.remove();
        }
        return rc;
    }

    public static boolean setProperties(Object target, Map props) {
        return IntrospectionSupport.setProperties(target, props, true);
    }

    public static boolean setProperties(Object target, Map props, boolean removeIfSet) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!IntrospectionSupport.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            if (removeIfSet) {
                iter.remove();
            }
            rc = true;
        }
        return rc;
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            Method setter;
            Class<Object> clazz = target.getClass();
            if (target instanceof SSLServerSocket) {
                clazz = SSLServerSocket.class;
            }
            if ((setter = IntrospectionSupport.findSetterMethod(clazz, name)) == null) {
                return false;
            }
            setter.setAccessible(true);
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, TypeConversionSupport.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Throwable e) {
            System.out.printf("Could not set property %s on %s\n", name, target);
            e.printStackTrace();
            return false;
        }
    }

    public static Method findSetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        name = "set" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            return method;
        }
        return null;
    }

    public static Method findGetterMethod(Class<?> clazz, String name) {
        Method[] methods;
        name = "get" + Character.toUpperCase(name.charAt(0)) + name.substring(1);
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 0) continue;
            return method;
        }
        return null;
    }

    public static <T> T getProperty(Object target, String name, Class<T> targetClass) {
        Class<Object> clazz = target.getClass();
        try {
            Method getter;
            if (target instanceof SSLServerSocket) {
                clazz = SSLServerSocket.class;
            }
            if ((getter = IntrospectionSupport.findGetterMethod(clazz, name)) == null) {
                try {
                    Field field = clazz.getDeclaredField(name);
                    field.setAccessible(true);
                    return TypeConversionSupport.convert(field.get(target), targetClass);
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
            getter.setAccessible(true);
            Object value = getter.invoke(target, new Object[0]);
            return TypeConversionSupport.convert(value, targetClass);
        }
        catch (Throwable e) {
            System.out.printf("Could not get property %s on %s\n", name, target);
            e.printStackTrace();
            return null;
        }
    }

    public static String toString(Object target) {
        return IntrospectionSupport.toString(target, Object.class, null);
    }

    public static String toString(Object target, Class<Object> stopClass) {
        return IntrospectionSupport.toString(target, stopClass, null);
    }

    public static String toString(Object target, Class<Object> stopClass, Map<String, Object> overrideFields) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        IntrospectionSupport.addFields(target, target.getClass(), stopClass, map);
        if (overrideFields != null) {
            for (String key : overrideFields.keySet()) {
                Object value = overrideFields.get(key);
                map.put(key, value);
            }
        }
        StringBuffer buffer = new StringBuffer(IntrospectionSupport.simpleName(target.getClass()));
        buffer.append(" {");
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        boolean first = true;
        for (Map.Entry<String, Object> entry : entrySet) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append((Object)key);
            buffer.append(" = ");
            IntrospectionSupport.appendToString(buffer, key, value);
        }
        buffer.append("}");
        return buffer.toString();
    }

    protected static void appendToString(StringBuffer buffer, Object key, Object value) {
        if (key.toString().toLowerCase(Locale.ENGLISH).contains("password")) {
            buffer.append("*****");
        } else {
            buffer.append(value);
        }
    }

    public static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        return name;
    }

    private static void addFields(Object target, Class<?> startClass, Class<Object> stopClass, LinkedHashMap<String, Object> map) {
        Field[] fields;
        if (startClass != stopClass) {
            IntrospectionSupport.addFields(target, startClass.getSuperclass(), stopClass, map);
        }
        for (Field field : fields = startClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isPrivate(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                List<Object> o = field.get(target);
                if (o != null && o.getClass().isArray()) {
                    try {
                        o = Arrays.asList((Object[])o);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                map.put(field.getName(), o);
            }
            catch (Throwable e) {
                System.out.println("Error getting field " + field + " on class " + startClass + ". This exception is ignored.");
                e.printStackTrace();
            }
        }
    }
}

