/*
 * Decompiled with CFR 0.152.
 */
package gu.simplemq.utils;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class TypeConversionSupport {
    private static final Converter IDENTITY_CONVERTER = new Converter(){

        @Override
        public Object convert(Object value) {
            return value;
        }
    };
    private static final Map<ConversionKey, Converter> CONVERSION_MAP = new HashMap<ConversionKey, Converter>();

    private TypeConversionSupport() {
    }

    public static <T> T valueOf(Map props, String key, Class<T> to) {
        if (props == null || key == null || to == null) {
            return null;
        }
        Object value = props.get(key);
        return TypeConversionSupport.convert(value, to);
    }

    public static String stringValueOf(Map props, String key) {
        return TypeConversionSupport.valueOf(props, key, String.class);
    }

    public static Integer intValueOf(Map props, String key) {
        return TypeConversionSupport.valueOf(props, key, Integer.class);
    }

    public static Converter lookupConverter(Class<?> from, Class<?> to) {
        if (from.isPrimitive()) {
            from = TypeConversionSupport.convertPrimitiveTypeToWrapperType(from);
        }
        if (to.isPrimitive()) {
            to = TypeConversionSupport.convertPrimitiveTypeToWrapperType(to);
        }
        if (from.equals(to)) {
            return IDENTITY_CONVERTER;
        }
        return CONVERSION_MAP.get(new ConversionKey(from, to));
    }

    private static Class<?> convertPrimitiveTypeToWrapperType(Class<?> type) {
        Class<Object> rc = type;
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                rc = Integer.class;
            } else if (type == Long.TYPE) {
                rc = Long.class;
            } else if (type == Double.TYPE) {
                rc = Double.class;
            } else if (type == Float.TYPE) {
                rc = Float.class;
            } else if (type == Short.TYPE) {
                rc = Short.class;
            } else if (type == Byte.TYPE) {
                rc = Byte.class;
            } else if (type == Boolean.TYPE) {
                rc = Boolean.class;
            }
        }
        return rc;
    }

    public static String[] convertToStringArray(Object value) {
        if (value == null) {
            return null;
        }
        String text = value.toString();
        if (text == null || text.length() == 0) {
            return null;
        }
        StringTokenizer stok = new StringTokenizer(text, ",");
        ArrayList<String> list = new ArrayList<String>();
        while (stok.hasMoreTokens()) {
            list.add(stok.nextToken());
        }
        String[] array = list.toArray(new String[list.size()]);
        return array;
    }

    public static String convertToString(String[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer(String.valueOf(value[0]));
        for (int i = 1; i < value.length; ++i) {
            result.append(",").append(value[i]);
        }
        return result.toString();
    }

    public static final <L, R> R convert(L value, Class<L> left, Class<R> right) {
        if (null == value) {
            if (Boolean.TYPE.isAssignableFrom(right)) {
                return (R)Boolean.FALSE;
            }
            return null;
        }
        if (Preconditions.checkNotNull(right, "right is null").isInstance(value)) {
            return right.cast(value);
        }
        Converter converter = TypeConversionSupport.lookupConverter(MoreObjects.firstNonNull(left, value.getClass()), right);
        Preconditions.checkArgument(converter != null, "Cannot convert from " + value.getClass() + " to " + right + " with value " + value);
        return (R)converter.convert(value);
    }

    public static final <R> R convert(Object value, Class<R> right) {
        return TypeConversionSupport.convert(value, null, right);
    }

    static {
        Converter toStringConverter = new Converter(){

            @Override
            public Object convert(Object value) {
                return value.toString();
            }
        };
        CONVERSION_MAP.put(new ConversionKey(Boolean.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Byte.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Short.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Integer.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Long.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Float.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(Double.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(URI.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(BigInteger.class, String.class), toStringConverter);
        CONVERSION_MAP.put(new ConversionKey(String.class, Boolean.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return value == null ? false : ((String)value).toLowerCase().matches("true|yes|on");
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Byte.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Byte.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Short.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Short.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Integer.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Integer.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Long.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Long.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Float.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Float.valueOf((String)value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, Double.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return Double.valueOf((String)value);
            }
        });
        Converter longConverter = new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).longValue();
            }
        };
        CONVERSION_MAP.put(new ConversionKey(Byte.class, Long.class), longConverter);
        CONVERSION_MAP.put(new ConversionKey(Short.class, Long.class), longConverter);
        CONVERSION_MAP.put(new ConversionKey(Integer.class, Long.class), longConverter);
        CONVERSION_MAP.put(new ConversionKey(Date.class, Long.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Date)value).getTime();
            }
        });
        Converter intConverter = new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).intValue();
            }
        };
        CONVERSION_MAP.put(new ConversionKey(Byte.class, Integer.class), intConverter);
        CONVERSION_MAP.put(new ConversionKey(Short.class, Integer.class), intConverter);
        CONVERSION_MAP.put(new ConversionKey(Byte.class, Short.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return ((Number)value).shortValue();
            }
        });
        CONVERSION_MAP.put(new ConversionKey(Float.class, Double.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return new Double(((Number)value).doubleValue());
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, URI.class), new Converter(){

            @Override
            public Object convert(Object value) {
                String text = value.toString();
                try {
                    return new URI(text);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String.class, char[].class), new Converter(){

            @Override
            public Object convert(Object value) {
                return ((String)value).toCharArray();
            }
        });
        CONVERSION_MAP.put(new ConversionKey(Object.class, String[].class), new Converter(){

            @Override
            public Object convert(Object value) {
                return TypeConversionSupport.convertToStringArray(value);
            }
        });
        CONVERSION_MAP.put(new ConversionKey(String[].class, String.class), new Converter(){

            @Override
            public Object convert(Object value) {
                return TypeConversionSupport.convertToString((String[])value);
            }
        });
    }

    public static interface Converter {
        public Object convert(Object var1);
    }

    private static class ConversionKey {
        final Class<?> from;
        final Class<?> to;
        final int hashCode;

        public ConversionKey(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
            this.hashCode = from.hashCode() ^ to.hashCode() << 1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConversionKey other = (ConversionKey)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

