/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.StringTokenizer;
import jcifs.context.SingletonContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);

    public static void registerSmbURLHandler() {
        SingletonContext.registerSmbURLHandler();
    }

    public static int getInt(Properties props, String key, int def) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                def = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                log.error("Not a number", nfe);
            }
        }
        return def;
    }

    public static int getInt(Properties props, String key) {
        String s = props.getProperty(key);
        int result = -1;
        if (s != null) {
            try {
                result = Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                log.error("Not a number", nfe);
            }
        }
        return result;
    }

    public static long getLong(Properties props, String key, long def) {
        String s = props.getProperty(key);
        if (s != null) {
            try {
                def = Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                log.error("Not a number", nfe);
            }
        }
        return def;
    }

    public static InetAddress getInetAddress(Properties props, String key, InetAddress def) {
        String addr = props.getProperty(key);
        if (addr != null) {
            try {
                def = InetAddress.getByName(addr);
            }
            catch (UnknownHostException uhe) {
                log.error("Unknown host " + addr, uhe);
            }
        }
        return def;
    }

    public static InetAddress getLocalHost(Properties props) {
        String addr = props.getProperty("jcifs.smb.client.laddr");
        if (addr != null) {
            try {
                return InetAddress.getByName(addr);
            }
            catch (UnknownHostException uhe) {
                log.error("Ignoring jcifs.smb.client.laddr address: " + addr, uhe);
            }
        }
        return null;
    }

    public static boolean getBoolean(Properties props, String key, boolean def) {
        String b = props.getProperty(key);
        if (b != null) {
            def = b.toLowerCase().equals("true");
        }
        return def;
    }

    public static InetAddress[] getInetAddressArray(Properties props, String key, String delim, InetAddress[] def) {
        String p = props.getProperty(key);
        if (p != null) {
            StringTokenizer tok = new StringTokenizer(p, delim);
            int len = tok.countTokens();
            InetAddress[] arr = new InetAddress[len];
            for (int i = 0; i < len; ++i) {
                String addr = tok.nextToken();
                try {
                    arr[i] = InetAddress.getByName(addr);
                    continue;
                }
                catch (UnknownHostException uhe) {
                    log.error("Unknown host " + addr, uhe);
                    return def;
                }
            }
            return arr;
        }
        return def;
    }
}

