/*
 * Decompiled with CFR 0.152.
 */
package jcifs.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jcifs.Address;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.Config;
import jcifs.DfsReferralData;
import jcifs.NameServiceClient;
import jcifs.config.PropertyConfiguration;
import jcifs.context.BaseContext;
import jcifs.http.NtlmSsp;
import jcifs.smb.DfsReferral;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbAuthException;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbFileInputStream;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class NetworkExplorer
extends HttpServlet {
    private static final long serialVersionUID = -3847521461674504364L;
    private static final Logger log = LoggerFactory.getLogger(NetworkExplorer.class);
    private String style;
    private boolean credentialsSupplied;
    private boolean enableBasic;
    private boolean insecureBasic;
    private String realm;
    private String defaultDomain;
    private CIFSContext transportContext;

    public void init() throws ServletException {
        StringBuffer sb = new StringBuffer();
        byte[] buf = new byte[1024];
        Properties p = new Properties();
        p.putAll((Map<?, ?>)System.getProperties());
        p.setProperty("jcifs.smb.client.soTimeout", "600000");
        p.setProperty("jcifs.smb.client.attrExpirationPeriod", "300000");
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("jcifs.")) continue;
            p.setProperty(name, this.getInitParameter(name));
        }
        try {
            if (p.getProperty("jcifs.smb.client.username") == null) {
                new NtlmSsp();
            } else {
                this.credentialsSupplied = true;
            }
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jcifs/http/ne.css");){
                int n;
                while ((n = is.read(buf)) != -1) {
                    sb.append(new String(buf, 0, n, "ISO8859_1"));
                }
                this.style = sb.toString();
            }
            catch (IOException ioe) {
                throw new ServletException(ioe.getMessage());
            }
            this.enableBasic = Config.getBoolean(p, "jcifs.http.enableBasic", false);
            this.insecureBasic = Config.getBoolean(p, "jcifs.http.insecureBasic", false);
            this.realm = p.getProperty("jcifs.http.basicRealm");
            if (this.realm == null) {
                this.realm = "jCIFS";
            }
            this.defaultDomain = p.getProperty("jcifs.smb.client.domain");
            this.transportContext = new BaseContext(new PropertyConfiguration(p));
        }
        catch (CIFSException ex) {
            throw new ServletException("Failed to initialize CIFS context", (Throwable)ex);
        }
    }

    protected void doFile(HttpServletRequest req, HttpServletResponse resp, SmbFile file) throws IOException {
        byte[] buf = new byte[8192];
        ServletOutputStream out = resp.getOutputStream();
        try (SmbFileInputStream in = new SmbFileInputStream(file);){
            int n;
            String url = file.getLocator().getPath();
            resp.setContentType("text/plain");
            resp.setContentType(URLConnection.guessContentTypeFromName(url));
            resp.setHeader("Content-Length", file.length() + "");
            resp.setHeader("Accept-Ranges", "Bytes");
            while ((n = in.read(buf)) != -1) {
                out.write(buf, 0, n);
            }
        }
    }

    protected int compareNames(SmbFile f1, String f1name, SmbFile f2) throws IOException {
        if (f1.isDirectory() != f2.isDirectory()) {
            return f1.isDirectory() ? -1 : 1;
        }
        return f1name.compareToIgnoreCase(f2.getName());
    }

    protected int compareSizes(SmbFile f1, String f1name, SmbFile f2) throws IOException {
        if (f1.isDirectory() != f2.isDirectory()) {
            return f1.isDirectory() ? -1 : 1;
        }
        if (f1.isDirectory()) {
            return f1name.compareToIgnoreCase(f2.getName());
        }
        long diff = f1.length() - f2.length();
        if (diff == 0L) {
            return f1name.compareToIgnoreCase(f2.getName());
        }
        return diff > 0L ? -1 : 1;
    }

    protected int compareTypes(SmbFile f1, String f1name, SmbFile f2) throws IOException {
        if (f1.isDirectory() != f2.isDirectory()) {
            return f1.isDirectory() ? -1 : 1;
        }
        String f2name = f2.getName();
        if (f1.isDirectory()) {
            return f1name.compareToIgnoreCase(f2name);
        }
        int i = f1name.lastIndexOf(46);
        String t1 = i == -1 ? "" : f1name.substring(i + 1);
        i = f2name.lastIndexOf(46);
        String t2 = i == -1 ? "" : f2name.substring(i + 1);
        if ((i = t1.compareToIgnoreCase(t2)) == 0) {
            return f1name.compareToIgnoreCase(f2name);
        }
        return i;
    }

    protected int compareDates(SmbFile f1, String f1name, SmbFile f2) throws IOException {
        if (f1.isDirectory() != f2.isDirectory()) {
            return f1.isDirectory() ? -1 : 1;
        }
        if (f1.isDirectory()) {
            return f1name.compareToIgnoreCase(f2.getName());
        }
        return f1.lastModified() > f2.lastModified() ? -1 : 1;
    }

    protected void doDirectory(HttpServletRequest req, HttpServletResponse resp, SmbFile dir) throws IOException {
        ListIterator iter;
        String name;
        int i;
        PrintWriter out = resp.getWriter();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/d/yy h:mm a");
        GregorianCalendar cal = new GregorianCalendar();
        sdf.setCalendar(cal);
        SmbFile[] dirents = dir.listFiles();
        if (log.isDebugEnabled()) {
            log.debug(dirents.length + " items listed");
        }
        LinkedList<SmbFile> sorted = new LinkedList<SmbFile>();
        String fmt = req.getParameter("fmt");
        if (fmt == null) {
            fmt = "col";
        }
        int sort = 0;
        String str = req.getParameter("sort");
        if (str == null || str.equals("name")) {
            sort = 0;
        } else if (str.equals("size")) {
            sort = 1;
        } else if (str.equals("type")) {
            sort = 2;
        } else if (str.equals("date")) {
            sort = 3;
        }
        int fileCount = 0;
        int dirCount = 0;
        int maxLen = 28;
        for (i = 0; i < dirents.length; ++i) {
            int len;
            block32: {
                try {
                    if (dirents[i].getType() == 16) {
                        continue;
                    }
                }
                catch (SmbAuthException sae) {
                    log.warn("Auth failed", sae);
                }
                catch (SmbException se) {
                    log.warn("Connection failed", se);
                    if (se.getNtStatus() == -1073741823) break block32;
                    throw se;
                }
            }
            if (dirents[i].isDirectory()) {
                ++dirCount;
            } else {
                ++fileCount;
            }
            name = dirents[i].getName();
            if (log.isDebugEnabled()) {
                log.debug(i + ": " + name);
            }
            if ((len = name.length()) > maxLen) {
                maxLen = len;
            }
            iter = sorted.listIterator();
            int j = 0;
            while (iter.hasNext() && !(sort == 0 ? this.compareNames(dirents[i], name, (SmbFile)iter.next()) < 0 : (sort == 1 ? this.compareSizes(dirents[i], name, (SmbFile)iter.next()) < 0 : (sort == 2 ? this.compareTypes(dirents[i], name, (SmbFile)iter.next()) < 0 : sort == 3 && this.compareDates(dirents[i], name, (SmbFile)iter.next()) < 0)))) {
                ++j;
            }
            sorted.add(j, dirents[i]);
        }
        if (maxLen > 50) {
            maxLen = 50;
        }
        maxLen *= 9;
        resp.setContentType("text/html");
        out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
        out.println("<html><head><title>Network Explorer</title>");
        out.println("<meta HTTP-EQUIV=\"Pragma\" CONTENT=\"no-cache\">");
        out.println("<style TYPE=\"text/css\">");
        out.println(this.style);
        if (dirents.length < 200) {
            out.println("    a:hover {");
            out.println("        background: #a2ff01;");
            out.println("    }");
        }
        out.println("</STYLE>");
        out.println("</head><body>");
        out.print("<a class=\"sort\" style=\"width: " + maxLen + ";\" href=\"?fmt=detail&sort=name\">Name</a>");
        out.println("<a class=\"sort\" href=\"?fmt=detail&sort=size\">Size</a>");
        out.println("<a class=\"sort\" href=\"?fmt=detail&sort=type\">Type</a>");
        out.println("<a class=\"sort\" style=\"width: 180\" href=\"?fmt=detail&sort=date\">Modified</a><br clear='all'><p>");
        String path = dir.getLocator().getCanonicalURL();
        if (path.length() < 7) {
            out.println("<b><big>smb://</big></b><br>");
            path = ".";
        } else {
            out.println("<b><big>" + path + "</big></b><br>");
            path = "../";
        }
        out.println(dirCount + fileCount + " objects (" + dirCount + " directories, " + fileCount + " files)<br>");
        out.println("<b><a class=\"plain\" href=\".\">normal</a> | <a class=\"plain\" href=\"?fmt=detail\">detailed</a></b>");
        out.println("<p><table border='0' cellspacing='0' cellpadding='0'><tr><td>");
        out.print("<A style=\"width: " + maxLen);
        out.print("; height: 18;\" HREF=\"");
        out.print(path);
        out.println("\"><b>&uarr;</b></a>");
        if (fmt.equals("detail")) {
            out.println("<br clear='all'>");
        }
        if (path.length() == 1 || dir.getType() != 2) {
            path = "";
        }
        iter = sorted.listIterator();
        while (iter.hasNext()) {
            SmbFile f = (SmbFile)iter.next();
            name = f.getName();
            if (fmt.equals("detail")) {
                out.print("<A style=\"width: " + maxLen);
                out.print("; height: 18;\" HREF=\"");
                out.print(path);
                out.print(name);
                if (f.isDirectory()) {
                    out.print("?fmt=detail\"><b>");
                    out.print(name);
                    out.print("</b></a>");
                } else {
                    out.print("\"><b>");
                    out.print(name);
                    out.print("</b></a><div align='right'>");
                    out.print(f.length() / 1024L + " KB </div><div>");
                    i = name.lastIndexOf(46) + 1;
                    if (i > 1 && name.length() - i < 6) {
                        out.print(name.substring(i).toUpperCase() + "</div class='ext'>");
                    } else {
                        out.print("&nbsp;</div>");
                    }
                    out.print("<div style='width: 180'>");
                    out.print(sdf.format(new Date(f.lastModified())));
                    out.print("</div>");
                }
                out.println("<br clear='all'>");
                continue;
            }
            out.print("<A style=\"width: " + maxLen);
            if (f.isDirectory()) {
                out.print("; height: 18;\" HREF=\"");
                out.print(path);
                out.print(name);
                out.print("\"><b>");
                out.print(name);
                out.print("</b></a>");
                continue;
            }
            out.print(";\" HREF=\"");
            out.print(path);
            out.print(name);
            out.print("\"><b>");
            out.print(name);
            out.print("</b><br><small>");
            out.print(f.length() / 1024L + "KB <br>");
            out.print(sdf.format(new Date(f.lastModified())));
            out.print("</small>");
            out.println("</a>");
        }
        out.println("</td></tr></table>");
        out.println("</BODY></HTML>");
        out.close();
    }

    private static String parseServerAndShare(String pathInfo) {
        char ch;
        int p;
        char[] out = new char[256];
        if (pathInfo == null) {
            return null;
        }
        int len = pathInfo.length();
        int i = 0;
        for (p = 0; p < len && pathInfo.charAt(p) == '/'; ++p) {
        }
        if (p == len) {
            return null;
        }
        while (p < len && (ch = pathInfo.charAt(p)) != '/') {
            out[i++] = ch;
            ++p;
        }
        while (p < len && pathInfo.charAt(p) == '/') {
            ++p;
        }
        if (p < len) {
            out[i++] = 47;
            do {
                out[i++] = ch = pathInfo.charAt(p++);
            } while (p < len && ch != '/');
        }
        return new String(out, 0, i);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        boolean offerBasic;
        int i;
        String server = null;
        boolean possibleWorkgroup = true;
        NtlmPasswordAuthentication ntlm = null;
        HttpSession ssn = req.getSession(false);
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && (server = NetworkExplorer.parseServerAndShare(pathInfo)) != null && (i = server.indexOf(47)) > 0) {
            server = server.substring(0, i).toLowerCase();
            possibleWorkgroup = false;
        }
        String msg = req.getHeader("Authorization");
        boolean bl = offerBasic = this.enableBasic && (this.insecureBasic || req.isSecure());
        if (msg != null && (msg.startsWith("NTLM ") || offerBasic && msg.startsWith("Basic "))) {
            if (msg.startsWith("NTLM ")) {
                Address dc;
                NameServiceClient nameServiceClient = this.getTransportContext().getNameServiceClient();
                if (pathInfo == null || server == null) {
                    String mb = nameServiceClient.getNbtByName("\u0001\u0002__MSBROWSE__\u0002", 1, null).getHostAddress();
                    dc = nameServiceClient.getByName(mb);
                } else {
                    dc = nameServiceClient.getByName(server, possibleWorkgroup);
                }
                req.getSession();
                byte[] challenge = this.getTransportContext().getTransportPool().getChallenge(this.getTransportContext(), dc);
                ntlm = NtlmSsp.authenticate(this.getTransportContext(), req, resp, challenge);
                if (ntlm == null) {
                    return;
                }
            } else {
                String auth = new String(Base64.decode((String)msg.substring(6)), "US-ASCII");
                int index = auth.indexOf(58);
                String user = index != -1 ? auth.substring(0, index) : auth;
                String password = index != -1 ? auth.substring(index + 1) : "";
                index = user.indexOf(92);
                if (index == -1) {
                    index = user.indexOf(47);
                }
                String domain = index != -1 ? user.substring(0, index) : this.defaultDomain;
                user = index != -1 ? user.substring(index + 1) : user;
                ntlm = new NtlmPasswordAuthentication(this.getTransportContext(), domain, user, password);
            }
            req.getSession().setAttribute("npa-" + server, (Object)ntlm);
        } else if (!this.credentialsSupplied) {
            if (ssn != null) {
                ntlm = (NtlmPasswordAuthentication)ssn.getAttribute("npa-" + server);
            }
            if (ntlm == null) {
                resp.setHeader("WWW-Authenticate", "NTLM");
                if (offerBasic) {
                    resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
                }
                resp.setHeader("Connection", "close");
                resp.setStatus(401);
                resp.flushBuffer();
                return;
            }
        }
        try (SmbFile file = this.openFile(pathInfo, server);){
            if (file.isDirectory()) {
                this.doDirectory(req, resp, file);
            } else {
                this.doFile(req, resp, file);
            }
        }
        catch (SmbAuthException sae) {
            if (ssn != null) {
                ssn.removeAttribute("npa-" + server);
            }
            if (sae.getNtStatus() == -1073741819) {
                resp.sendRedirect(req.getRequestURL().toString());
                return;
            }
            resp.setHeader("WWW-Authenticate", "NTLM");
            if (offerBasic) {
                resp.addHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            }
            resp.setHeader("Connection", "close");
            resp.setStatus(401);
            resp.flushBuffer();
            return;
        }
        catch (DfsReferral dr) {
            StringBuffer redir = req.getRequestURL();
            String qs = req.getQueryString();
            DfsReferralData refdata = dr.getData();
            redir = new StringBuffer(redir.substring(0, redir.length() - req.getPathInfo().length()));
            redir.append('/');
            redir.append(refdata.getServer());
            redir.append('/');
            redir.append(refdata.getShare());
            redir.append('/');
            if (qs != null) {
                redir.append(req.getQueryString());
            }
            resp.sendRedirect(redir.toString());
            resp.flushBuffer();
            return;
        }
    }

    private SmbFile openFile(String pathInfo, String server) throws MalformedURLException {
        SmbFile file = server == null ? new SmbFile("smb://", this.getTransportContext()) : new SmbFile("smb:/" + pathInfo, this.getTransportContext());
        return file;
    }

    private CIFSContext getTransportContext() {
        return this.transportContext;
    }
}

