/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.CIFSException;
import jcifs.ResourceNameFilter;
import jcifs.SmbResource;
import jcifs.internal.smb2.create.Smb2CloseRequest;
import jcifs.internal.smb2.create.Smb2CreateRequest;
import jcifs.internal.smb2.create.Smb2CreateResponse;
import jcifs.internal.smb2.info.Smb2QueryDirectoryRequest;
import jcifs.internal.smb2.info.Smb2QueryDirectoryResponse;
import jcifs.smb.DirFileEntryEnumIteratorBase;
import jcifs.smb.FileEntry;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbTreeHandleImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirFileEntryEnumIterator2
extends DirFileEntryEnumIteratorBase {
    private static final Logger log = LoggerFactory.getLogger(DirFileEntryEnumIterator2.class);
    private byte[] fileId;
    private Smb2QueryDirectoryResponse response;

    public DirFileEntryEnumIterator2(SmbTreeHandleImpl th, SmbResource parent, String wildcard, ResourceNameFilter filter, int searchAttributes) throws CIFSException {
        super(th, parent, wildcard, filter, searchAttributes);
    }

    @Override
    protected FileEntry[] getResults() {
        FileEntry[] results = this.response.getResults();
        if (results == null) {
            return new FileEntry[0];
        }
        return results;
    }

    @Override
    protected FileEntry open() throws CIFSException {
        Smb2CreateResponse createResp;
        SmbTreeHandleImpl th = this.getTreeHandle();
        String uncPath = this.getParent().getLocator().getUNCPath();
        Smb2CreateRequest create = new Smb2CreateRequest(th.getConfig(), uncPath);
        create.setCreateOptions(1);
        Smb2QueryDirectoryRequest query = new Smb2QueryDirectoryRequest(th.getConfig());
        query.setFileName(this.getWildcard());
        create.chain(query);
        try {
            createResp = th.send(create, new RequestParam[0]);
        }
        catch (SmbException e) {
            Smb2QueryDirectoryResponse qr;
            Smb2CreateResponse cr = (Smb2CreateResponse)create.getResponse();
            if (cr != null && cr.isReceived() && cr.getStatus() == 0) {
                try {
                    th.send(new Smb2CloseRequest(th.getConfig(), cr.getFileId()), new RequestParam[0]);
                }
                catch (SmbException e2) {
                    e.addSuppressed(e2);
                }
            }
            if ((qr = (Smb2QueryDirectoryResponse)query.getResponse()) != null && qr.isReceived() && qr.getStatus() == -1073741809) {
                this.doClose();
                return null;
            }
            throw e;
        }
        this.fileId = createResp.getFileId();
        this.response = (Smb2QueryDirectoryResponse)query.getResponse();
        FileEntry n = this.advance(false);
        if (n == null) {
            this.doClose();
        }
        return n;
    }

    @Override
    protected boolean fetchMore() throws CIFSException {
        FileEntry[] results = this.response.getResults();
        SmbTreeHandleImpl th = this.getTreeHandle();
        Smb2QueryDirectoryRequest query = new Smb2QueryDirectoryRequest(th.getConfig(), this.fileId);
        query.setFileName(this.getWildcard());
        query.setFileIndex(results[results.length - 1].getFileIndex());
        query.setQueryFlags((byte)4);
        try {
            Smb2QueryDirectoryResponse r = th.send(query, new RequestParam[0]);
            if (r.getStatus() == -2147483642) {
                return false;
            }
            this.response = r;
        }
        catch (SmbException e) {
            if (e.getNtStatus() == -2147483642) {
                log.debug("End of listing", e);
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    protected boolean isDone() {
        return false;
    }

    @Override
    protected void doCloseInternal() throws CIFSException {
        try {
            SmbTreeHandleImpl th = this.getTreeHandle();
            if (this.fileId != null && th.isConnected()) {
                th.send(new Smb2CloseRequest(th.getConfig(), this.fileId), new RequestParam[0]);
            }
        }
        finally {
            this.fileId = null;
        }
    }
}

