/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.util.List;
import jcifs.CIFSException;
import jcifs.FileNotifyInformation;
import jcifs.SmbWatchHandle;
import jcifs.internal.CommonServerMessageBlockRequest;
import jcifs.internal.NotifyResponse;
import jcifs.internal.smb1.trans.nt.NtTransNotifyChange;
import jcifs.internal.smb1.trans.nt.NtTransNotifyChangeResponse;
import jcifs.internal.smb2.notify.Smb2ChangeNotifyRequest;
import jcifs.smb.RequestParam;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFileHandleImpl;
import jcifs.smb.SmbTreeHandleImpl;
import jcifs.smb.SmbUnsupportedOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmbWatchHandleImpl
implements SmbWatchHandle {
    private static final Logger log = LoggerFactory.getLogger(SmbWatchHandleImpl.class);
    private final SmbFileHandleImpl handle;
    private final int filter;
    private final boolean recursive;

    public SmbWatchHandleImpl(SmbFileHandleImpl fh, int filter, boolean recursive) {
        this.handle = fh;
        this.filter = filter;
        this.recursive = recursive;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<FileNotifyInformation> watch() throws CIFSException {
        NotifyResponse resp;
        if (!this.handle.isValid()) {
            throw new SmbException("Watch was broken by tree disconnect");
        }
        SmbTreeHandleImpl th = this.handle.getTree();
        Throwable throwable = null;
        try {
            CommonServerMessageBlockRequest req;
            resp = null;
            if (th.isSMB2()) {
                Smb2ChangeNotifyRequest r = new Smb2ChangeNotifyRequest(th.getConfig(), this.handle.getFileId());
                r.setCompletionFilter(this.filter);
                r.setNotifyFlags(this.recursive ? 1 : 0);
                req = r;
            } else {
                if (!th.hasCapability(16)) {
                    throw new SmbUnsupportedOperationException("Not supported without CAP_NT_SMBS");
                }
                req = new NtTransNotifyChange(th.getConfig(), this.handle.getFid(), this.filter, this.recursive);
                resp = new NtTransNotifyChangeResponse(th.getConfig());
            }
            if (log.isTraceEnabled()) {
                log.trace("Sending NtTransNotifyChange for " + this.handle);
            }
            try {
                resp = th.send(req, resp, RequestParam.NO_TIMEOUT, RequestParam.NO_RETRY);
            }
            catch (SmbException e) {
                if (e.getNtStatus() != -1073741536) throw e;
                log.debug("Request was cancelled", e);
                List<FileNotifyInformation> list = null;
                if (th == null) return list;
                if (throwable == null) {
                    th.close();
                    return list;
                }
                try {
                    th.close();
                    return list;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                    return list;
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("Returned from NtTransNotifyChange " + resp.getErrorCode());
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        if (!resp.isReceived()) {
            throw new CIFSException("Did not receive response");
        }
        if (resp.getErrorCode() == 267) {
            this.handle.markClosed();
        }
        if (resp.getErrorCode() != 268) return resp.getNotifyInformation();
        resp.getNotifyInformation().clear();
        return resp.getNotifyInformation();
        finally {
            if (th != null) {
                if (throwable != null) {
                    try {
                        th.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    th.close();
                }
            }
        }
    }

    @Override
    public List<FileNotifyInformation> call() throws CIFSException {
        return this.watch();
    }

    @Override
    public void close() throws CIFSException {
        if (this.handle.isValid()) {
            this.handle.close(0L);
        }
    }
}

