/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cli;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.gdface.cli.CmdConfig;
import net.gdface.cli.CommonCliConstants;
import net.gdface.cli.Context;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.TypeHandler;

public abstract class AbstractConfiguration
extends Context
implements CommonCliConstants,
CmdConfig {
    protected final boolean withTrace;
    protected final Set<String> CONTROL_OPTIONS = new HashSet<String>(){
        {
            this.add("h");
            this.add("help");
            this.add("D");
        }
    };
    private final Map<String, PropertyDescriptor> fields;

    protected abstract Map<String, Object> getDefaultValueMap();

    protected AbstractConfiguration() {
        this(false);
    }

    protected AbstractConfiguration(boolean withTrace) {
        this.withTrace = withTrace;
        if (withTrace) {
            this.CONTROL_OPTIONS.add("X");
            this.CONTROL_OPTIONS.add("trace");
        }
        this.fields = this.initFields();
    }

    @Override
    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        Iterator<Option> it = options.getOptions().iterator();
        Map<String, Object> defaultMap = this.getDefaultValueMap();
        if (defaultMap == null) {
            defaultMap = Collections.emptyMap();
        }
        while (it.hasNext()) {
            Option opt = it.next();
            String key = opt.getLongOpt() == null ? opt.getOpt() : opt.getLongOpt();
            if (!this.isNeedOption(key)) continue;
            Object value = null;
            try {
                if (opt.hasArg()) {
                    if (cmd.hasOption(key)) {
                        if (opt.hasOptionalArg() && cmd.getOptionValues(key) == null) {
                            value = Boolean.TRUE;
                        } else if (opt.getArgs() == 1) {
                            value = cmd.getParsedOptionValue(key);
                        } else {
                            String[] values = cmd.getOptionValues(key);
                            if (values != null) {
                                value = Array.newInstance((Class)opt.getType(), values.length);
                                for (int i = 0; i < values.length; ++i) {
                                    Array.set(value, i, AbstractConfiguration.getParsedOptionValue(opt, values[i]));
                                }
                            }
                        }
                    }
                } else {
                    value = cmd.hasOption(key);
                }
            }
            catch (NoClassDefFoundError e) {
                System.out.printf("key=%s %s\n", key, cmd.getOptionValue(key));
                throw e;
            }
            if (null == value) {
                if (opt.isRequired()) {
                    throw new IllegalArgumentException(String.format("%s or %s not define", opt.getOpt(), opt.getLongOpt()));
                }
                if (!opt.hasOptionalArg()) {
                    if (!defaultMap.containsKey(key)) {
                        throw new IllegalArgumentException(String.format("%s or %s not default value", opt.getOpt(), opt.getLongOpt()));
                    }
                    value = defaultMap.get(key);
                }
            } else if (opt.hasOptionalArg() && Boolean.TRUE.equals(value) && defaultMap.containsKey(key)) {
                value = defaultMap.get(key);
            }
            this.setProperty(key, value);
        }
    }

    private final boolean isNeedOption(String opt) {
        return !this.CONTROL_OPTIONS.contains(opt);
    }

    private static Object getParsedOptionValue(Option option, String value) throws ParseException {
        if (option == null || value == null) {
            return null;
        }
        return TypeHandler.createValue(value, option.getType());
    }

    private Map<String, PropertyDescriptor> initFields() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.getClass());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
        HashMap<String, PropertyDescriptor> map = new HashMap<String, PropertyDescriptor>();
        if (descriptors != null) {
            for (PropertyDescriptor pd : descriptors) {
                Method method = pd.getReadMethod();
                if (method == null || method.getDeclaringClass() == Object.class) continue;
                map.put(pd.getName(), pd);
            }
        }
        return map;
    }

    public <T> T valueOf(String name) {
        PropertyDescriptor descriptor = this.fields.get(name);
        if (null == descriptor) {
            return null;
        }
        try {
            return (T)descriptor.getReadMethod().invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }
}

