/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cli;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import net.gdface.cli.AbstractConfiguration;
import net.gdface.cli.CommonCliConstants;
import net.gdface.cli.Context;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class BaseAppConfig
extends AbstractConfiguration
implements CommonCliConstants {
    protected static final Logger logger = Logger.getLogger(BaseAppConfig.class.getSimpleName());
    protected final Options options = new Options();
    protected final Context defaultValue = Context.builder().build();
    private boolean trace;

    protected BaseAppConfig() {
        this(false);
    }

    protected BaseAppConfig(boolean withTrace) {
        super(withTrace);
    }

    @Override
    protected Map<String, Object> getDefaultValueMap() {
        return this.defaultValue.getContext();
    }

    private void showError(Throwable e) {
        if (this.isTrace()) {
            e.printStackTrace();
        } else {
            logger.warning(String.format("%s:%s", e.getClass().getSimpleName(), e.getMessage()));
        }
    }

    public BaseAppConfig parseCommandLine(String[] args) {
        HelpFormatter formatter = new HelpFormatter();
        CmdParser parser = new CmdParser();
        CommandLine cl = null;
        Options opts = this.getOptions();
        opts.addOption("h", "help", false, "Print this usage information");
        if (this.withTrace) {
            opts.addOption("X", "trace", false, "show stack trace on error ,default: false");
        }
        boolean exit = false;
        try {
            cl = parser.parse(opts, args);
            this.trace = cl.hasOption("trace");
            if (!cl.hasOption("h")) {
                if (cl.hasOption("D")) {
                    this.setSystemProperty(cl.getOptionValues("D"));
                }
                this.loadConfig(opts, cl);
            } else {
                exit = true;
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof InvocationTargetException) {
                Throwable targetException = ((InvocationTargetException)e.getCause()).getTargetException();
                this.showError(targetException);
            } else {
                this.showError(e);
            }
            exit = true;
        }
        catch (Exception e) {
            this.showError(e);
            exit = true;
        }
        if (exit) {
            formatter.printHelp(this.getCmdLineSyntax(), this.getHeader(), this.getOptions(), this.getFooter());
            System.exit(1);
        }
        this.doAfterParse();
        return this;
    }

    private void setSystemProperty(String[] properties) {
        if (properties.length % 2 != 0) {
            throw new IllegalArgumentException("INVALID properties length");
        }
        for (int i = 0; i < properties.length; i += 2) {
            System.setProperty(properties[i], properties[i + 1]);
            logger.info(String.format("set property [%s]=[%s]", properties[i], properties[i + 1]));
        }
    }

    protected String getCmdLineSyntax() {
        return String.format("%s [options]", this.getAppName());
    }

    public Options getOptions() {
        return this.options;
    }

    protected String getAppName() {
        return "Appname";
    }

    protected String getHeader() {
        return null;
    }

    protected String getFooter() {
        return null;
    }

    protected void doAfterParse() {
    }

    protected Map<String, Object> doGetConstants() {
        return Collections.emptyMap();
    }

    public final <T> T getConstant(String name) {
        return (T)(name == null ? null : this.doGetConstants().get(name));
    }

    public boolean isTrace() {
        return this.trace;
    }

    public final <T extends BaseAppConfig> T self(Class<T> type) {
        return (T)this;
    }

    private class CmdParser
    extends DefaultParser {
        private CmdParser() {
        }

        @Override
        public CommandLine parse(Options options, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
            try {
                return super.parse(options, arguments, properties, stopAtNonOption);
            }
            catch (ParseException e) {
                if (this.cmd.hasOption("h")) {
                    return this.cmd;
                }
                throw e;
            }
        }
    }
}

