/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cli;

import java.util.HashMap;
import java.util.Map;

public class Context {
    private Map<String, Object> context = new HashMap<String, Object>();

    public static final Builder builder() {
        return new Builder();
    }

    public Context() {
    }

    public Context(Map<String, Object> map) {
        this.context.putAll(map);
    }

    public Context(Context context) {
        this.context.putAll(context.getContext());
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public Integer getInt(String name) {
        try {
            return (Integer)this.context.get(name);
        }
        catch (ClassCastException e) {
            Object v = this.context.get(name);
            if (v instanceof Number) {
                Number num = (Number)v;
                return num.intValue();
            }
            if (v instanceof String) {
                return Integer.valueOf((String)v);
            }
            throw e;
        }
    }

    public Long getLong(String name) {
        try {
            return (Long)this.context.get(name);
        }
        catch (ClassCastException e) {
            Object v = this.context.get(name);
            if (v instanceof Number) {
                Number num = (Number)v;
                return num.longValue();
            }
            if (v instanceof String) {
                return Long.valueOf((String)v);
            }
            throw e;
        }
    }

    public <T> T getProperty(String name) {
        Object value;
        try {
            value = this.context.get(name);
        }
        catch (ClassCastException e) {
            Object v = this.context.get(name);
            if (v instanceof Number) {
                value = (Number)v;
            }
            throw e;
        }
        return (T)value;
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public void setProperties(Map<String, ? extends Object> properties) {
        this.context.putAll(properties);
    }

    public <T> T setProperty(String name, T property) {
        return (T)this.context.put(name, property);
    }

    public static final class Builder {
        private final Map<String, Object> map = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder addProperties(Map<String, ? extends Object> properties) {
            if (properties != null) {
                this.map.putAll(properties);
            }
            return this;
        }

        public <T> Builder addProperty(String name, T property) {
            this.map.put(name, property);
            return this;
        }

        public Context build() {
            return new Context(this.map);
        }

        public <T extends Context> T build(Class<T> clazz) {
            Context instance;
            if (null == clazz) {
                throw new NullPointerException("clazz must not be null");
            }
            try {
                instance = (Context)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            instance.setProperties(this.map);
            return (T)instance;
        }
    }
}

