/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.cli;

import net.gdface.cli.BaseAppConfig;
import net.gdface.cli.ThriftServiceConstants;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class ThriftServiceConfig
extends BaseAppConfig
implements ThriftServiceConstants {
    private int servicePort;
    private int workThreads;
    private int connectionLimit;
    private int idleConnectionTimeout;

    public ThriftServiceConfig(int defaultPort) {
        if (defaultPort <= 0) {
            throw new IllegalArgumentException(String.format("invalid defaultPort %d", defaultPort));
        }
        this.options.addOption(Option.builder().longOpt("port").desc("service port number,default: " + defaultPort).numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("threads").desc("work thread number,default: count of available processors").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("connectionLimit").desc("an upper bound on the number of concurrent connections the server will accept.default:32").numberOfArgs(1).type(Number.class).build());
        this.options.addOption(Option.builder().longOpt("idleConnectionTimeout").desc("Sets a timeout(seconds) period between receiving requests from a client connection. If the timeout is exceeded (no complete requests have arrived from the client within the timeout), the server will disconnect the idle client.default:60 seconds").numberOfArgs(1).type(Number.class).build());
        this.defaultValue.setProperty("port", defaultPort);
        this.defaultValue.setProperty("threads", Runtime.getRuntime().availableProcessors());
        this.defaultValue.setProperty("connectionLimit", 32);
        this.defaultValue.setProperty("idleConnectionTimeout", 60);
    }

    @Override
    public void loadConfig(Options options, CommandLine cmd) throws ParseException {
        super.loadConfig(options, cmd);
        this.servicePort = ((Number)this.getProperty("port")).intValue();
        this.workThreads = ((Number)this.getProperty("threads")).intValue();
        this.connectionLimit = ((Number)this.getProperty("connectionLimit")).intValue();
        this.idleConnectionTimeout = ((Number)this.getProperty("idleConnectionTimeout")).intValue();
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public int getWorkThreads() {
        return this.workThreads;
    }

    public int getConnectionLimit() {
        return this.connectionLimit;
    }

    public int getIdleConnectionTimeout() {
        return this.idleConnectionTimeout;
    }
}

