/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.image;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.ServiceLoader;
import net.gdface.image.ImageMatrix;
import net.gdface.image.LazyImageFactory;
import net.gdface.image.MatType;
import net.gdface.image.NotFoundLazyImageFactoryException;
import net.gdface.image.NotImageException;
import net.gdface.image.UnsupportedFormatException;
import net.gdface.utils.Assert;
import net.gdface.utils.BaseVolatile;
import net.gdface.utils.BinaryUtils;
import net.gdface.utils.ILazyInitVariable;
import net.gdface.utils.Judge;

public abstract class BaseLazyImage
implements ImageMatrix {
    private static final ILazyInitVariable<LazyImageFactory> lazyImageFactory = new BaseVolatile<LazyImageFactory>(){

        @Override
        protected LazyImageFactory doGet() {
            ServiceLoader<LazyImageFactory> providers = ServiceLoader.load(LazyImageFactory.class);
            Iterator<LazyImageFactory> itor = providers.iterator();
            if (!itor.hasNext()) {
                throw new NotFoundLazyImageFactoryException();
            }
            return itor.next();
        }
    };
    protected byte[] imgBytes = null;
    protected File localFile = null;
    protected String md5 = null;
    protected String suffix = null;
    protected String mime = null;
    protected boolean autoClose = true;
    protected int width;
    protected int height;
    protected byte[] matrixRGB = null;
    protected byte[] matrixBGR = null;
    protected byte[] matrixGray = null;
    protected byte[] matrixRGBA = null;

    protected BaseLazyImage() {
    }

    public BaseLazyImage(byte[] imgBytes) {
        Assert.notEmpty(imgBytes, "imgBytes");
        this.imgBytes = imgBytes;
    }

    public BaseLazyImage(File src, String md5) throws FileNotFoundException {
        Assert.notNull(src, "src");
        this.localFile = src;
        if (!this.localFile.exists() || !this.localFile.isFile() || 0L == this.localFile.length()) {
            throw new FileNotFoundException(String.format("NOT EXIST OR NOT FILE OR ZERO bytes%s", this.localFile.getAbsolutePath()));
        }
        String fileName = this.localFile.getName();
        this.suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
        this.md5 = md5;
    }

    public byte[] getImgBytes() {
        if (null == this.imgBytes) {
            if (null != this.localFile) {
                try {
                    this.imgBytes = BinaryUtils.getBytesNotEmpty(this.localFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new IllegalArgumentException("while isValidImage be true localFile & imgBytes can't be NULL all");
            }
        }
        return this.imgBytes;
    }

    public String getMd5() {
        if (null == this.md5) {
            this.md5 = BinaryUtils.getMD5String(this.getImgBytes());
        }
        return this.md5;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getMime() {
        return this.mime;
    }

    public File getLocalFile() {
        return this.localFile;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public BaseLazyImage setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
        return this;
    }

    public void close() throws IOException {
    }

    public void finalize() throws Throwable {
        this.close();
        this.imgBytes = null;
        this.localFile = null;
    }

    public abstract <T extends BaseLazyImage> T open() throws UnsupportedFormatException, NotImageException;

    public File save(File folder) throws IOException {
        File file = new File(folder, this.getMd5() + (Judge.isEmpty(this.suffix) ? "" : "." + this.suffix));
        this.localFile = BinaryUtils.saveBytes(this.getImgBytes(), file, file.exists() && file.isFile() && 0L == file.length());
        return this.localFile;
    }

    public abstract byte[] wirtePNGBytes();

    public abstract byte[] wirteJPEGBytes();

    public void wirtePNGB(OutputStream out) throws IOException {
        Assert.notNull(out, "out");
        out.write(this.wirtePNGBytes());
    }

    public void wirteJPEG(OutputStream out) throws IOException {
        Assert.notNull(out, "out");
        out.write(this.wirteJPEGBytes());
    }

    @Override
    public byte[] getMatrixData(MatType matrixType) throws UnsupportedFormatException {
        if (matrixType == null) {
            throw new NullPointerException("matrixType is null");
        }
        switch (matrixType) {
            case RGB: {
                return this.getMatrixRGB();
            }
            case BGR: {
                return this.getMatrixBGR();
            }
            case RGBA: {
                return this.getMatrixRGBA();
            }
            case GRAY: {
                return this.getMatrixGray();
            }
        }
        throw new IllegalArgumentException("UNSUPPORTED matrix type " + (Object)((Object)matrixType) + " for getMatrixData");
    }

    public static final LazyImageFactory getLazyImageFactory() throws NotFoundLazyImageFactoryException {
        return lazyImageFactory.get();
    }
}

