/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.util.Arrays;
import net.gdface.image.LazyImage;
import net.gdface.image.NotImageException;
import net.gdface.image.UnsupportedFormatException;
import net.gdface.utils.Assert;
import net.gdface.utils.BinaryUtils;
import net.gdface.utils.Judge;

public final class Fingerprint {
    private static final int HASH_SIZE = 16;
    private final byte[] binaryzationMatrix;

    public Fingerprint(byte[] hashValue) {
        Assert.notEmpty(hashValue, "hashValue");
        if (hashValue.length != 256) {
            throw new IllegalArgumentException(String.format("length of hashValue must be %d", 256));
        }
        this.binaryzationMatrix = hashValue;
    }

    public Fingerprint(String hashValue) {
        this(Fingerprint.toBytes(hashValue));
    }

    public Fingerprint(Image src) {
        this(Fingerprint.hashValue(src));
    }

    private static byte[] hashValue(Image src) {
        Assert.notNull(src, "src");
        BufferedImage hashImage = Fingerprint.resize(src, 16, 16);
        byte[] matrixGray = (byte[])Fingerprint.toGray(hashImage).getData().getDataElements(0, 0, 16, 16, null);
        return Fingerprint.binaryzation(matrixGray);
    }

    public static <T> Fingerprint createFromImage(T src) throws UnsupportedFormatException, NotImageException {
        return null == src ? null : new Fingerprint(LazyImage.create(src).read(null, null));
    }

    public static <T> Fingerprint createFromImageNoThrow(T src) {
        try {
            return Fingerprint.createFromImage(src);
        }
        catch (UnsupportedFormatException e) {
            throw new RuntimeException(e);
        }
        catch (NotImageException e) {
            throw new RuntimeException(e);
        }
    }

    public static Fingerprint createFromCompact(byte[] compactValue) {
        return Judge.isEmpty(compactValue) ? null : new Fingerprint(Fingerprint.uncompact(compactValue));
    }

    public static Fingerprint createFromCompact(String compactValueHex) {
        return Judge.isEmpty(compactValueHex) ? null : new Fingerprint(Fingerprint.uncompact(BinaryUtils.hex2Bytes(compactValueHex)));
    }

    public static boolean validHashValue(byte[] hashValue) {
        Assert.notEmpty(hashValue, "hashValue");
        if (hashValue.length != 16) {
            return false;
        }
        for (byte b : hashValue) {
            if (0 == b || 1 == b) continue;
            return false;
        }
        return true;
    }

    public static boolean validHashValue(String hashValue) {
        Assert.notEmpty(hashValue, "hashValue");
        if (hashValue.length() != 16) {
            return false;
        }
        for (int i = 0; i < hashValue.length(); ++i) {
            if ('0' == hashValue.charAt(i) || '1' == hashValue.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public byte[] compact() {
        return Fingerprint.compact(this.binaryzationMatrix);
    }

    public String compactHEX() {
        return BinaryUtils.toHex(this.compact());
    }

    private static byte[] compact(byte[] hashValue) {
        Assert.notEmpty(hashValue, "hashValue");
        byte[] result = new byte[hashValue.length + 7 >> 3];
        int b = 0;
        for (int i = 0; i < hashValue.length; ++i) {
            if (0 == (i & 7)) {
                b = 0;
            }
            if (1 == hashValue[i]) {
                b = (byte)(b | 1 << (i & 7));
            } else if (hashValue[i] != 0) {
                throw new IllegalArgumentException("invalid hashValue,every element must be 0 or 1");
            }
            if (7 != (i & 7) && i != hashValue.length - 1) continue;
            result[i >> 3] = b;
        }
        return result;
    }

    private static byte[] uncompact(byte[] compactValue) {
        Assert.notEmpty(compactValue, "compactValue");
        byte[] result = new byte[compactValue.length << 3];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (compactValue[i >> 3] & 1 << (i & 7)) == 0 ? (byte)0 : 1;
        }
        return result;
    }

    private static byte[] toBytes(String hashValue) {
        Assert.notEmpty(hashValue, "hashValue");
        hashValue = hashValue.replaceAll("\\s", "");
        byte[] result = new byte[hashValue.length()];
        for (int i = 0; i < result.length; ++i) {
            char c = hashValue.charAt(i);
            if ('0' == c) {
                result[i] = 0;
                continue;
            }
            if ('1' == c) {
                result[i] = 1;
                continue;
            }
            throw new IllegalArgumentException("invalid hashValue String");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage resize(Image src, int width, int height) {
        Assert.notNull(src, "src");
        BufferedImage result = new BufferedImage(width, height, 5);
        Graphics g = result.getGraphics();
        try {
            g.drawImage(src.getScaledInstance(width, height, 4), 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return result;
    }

    private static int mean(byte[] src) {
        Assert.notEmpty(src, "src");
        long sum = 0L;
        for (byte b : src) {
            sum += (long)b & 0xFFL;
        }
        return Math.round((float)sum / (float)src.length);
    }

    private static byte[] binaryzation(byte[] src) {
        Assert.notEmpty(src, "src");
        byte[] dst = (byte[])src.clone();
        int mean = Fingerprint.mean(src);
        for (int i = 0; i < dst.length; ++i) {
            dst[i] = (byte)((dst[i] & 0xFF) >= mean ? 1 : 0);
        }
        return dst;
    }

    private static BufferedImage toGray(BufferedImage src) {
        Assert.notNull(src, "src");
        if (src.getType() == 10) {
            return src;
        }
        BufferedImage grayImage = new BufferedImage(src.getWidth(), src.getHeight(), 10);
        new ColorConvertOp(ColorSpace.getInstance(1003), null).filter(src, grayImage);
        return grayImage;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean multiLine) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        for (byte b : this.binaryzationMatrix) {
            buffer.append(0 == b ? (char)'0' : '1');
            if (!multiLine || ++count % 16 != 0) continue;
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof Fingerprint) {
            return Arrays.equals(this.binaryzationMatrix, ((Fingerprint)obj).binaryzationMatrix);
        }
        return false;
    }

    public float compareCompact(byte[] compactValue) {
        return this.compare(Fingerprint.createFromCompact(compactValue));
    }

    public float compare(String hashValue) {
        return this.compare(new Fingerprint(hashValue));
    }

    public float compare(byte[] hashValue) {
        return this.compare(new Fingerprint(hashValue));
    }

    public float compare(Image image2) {
        return this.compare(new Fingerprint(image2));
    }

    public float compare(Fingerprint src) {
        Assert.notNull(src, "src");
        if (src.binaryzationMatrix.length != this.binaryzationMatrix.length) {
            throw new IllegalArgumentException("length of hashValue is mismatch");
        }
        return Fingerprint.compare(this.binaryzationMatrix, src.binaryzationMatrix);
    }

    private static float compare(byte[] f1, byte[] f2) {
        Assert.notEmpty(f1, "f1");
        Assert.notEmpty(f2, "f2");
        if (f1.length != f2.length) {
            throw new IllegalArgumentException("mismatch FingerPrint length");
        }
        int sameCount = 0;
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] != f2[i]) continue;
            ++sameCount;
        }
        return (float)sameCount / (float)f1.length;
    }

    public static float compareCompact(byte[] f1, byte[] f2) {
        return Fingerprint.compare(Fingerprint.uncompact(f1), Fingerprint.uncompact(f2));
    }

    public static float compare(Image image1, Image image2) {
        Assert.notNull(image1, "image1");
        Assert.notNull(image2, "image2");
        return new Fingerprint(image1).compare(new Fingerprint(image2));
    }
}

