/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import net.gdface.utils.Assert;

public class ImageUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage resize(BufferedImage source, int targetWidth, int targetHeight, boolean constrain) {
        if (constrain) {
            double sy;
            double aspectRatio = (double)source.getWidth() / (double)source.getHeight();
            double sx = (double)targetWidth / (double)source.getWidth();
            if (sx > (sy = (double)targetHeight / (double)source.getHeight())) {
                targetWidth = (int)Math.round((double)targetHeight * aspectRatio);
            } else {
                targetHeight = (int)Math.round((double)targetWidth / aspectRatio);
            }
        }
        int type = source.getType();
        BufferedImage target = null;
        if (type == 0) {
            ColorModel cm = source.getColorModel();
            WritableRaster raster = cm.createCompatibleWritableRaster(targetWidth, targetHeight);
            target = new BufferedImage(cm, raster, cm.isAlphaPremultiplied(), null);
        } else {
            target = new BufferedImage(targetWidth, targetHeight, type);
        }
        Graphics2D g = target.createGraphics();
        try {
            g.drawImage(source.getScaledInstance(targetWidth, targetHeight, 4), 0, 0, null);
        }
        finally {
            g.dispose();
        }
        return target;
    }

    public static byte[] wirteJPEGBytes(BufferedImage source) {
        return ImageUtil.wirteJPEGBytes(source, null);
    }

    public static byte[] wirteBMPBytes(BufferedImage source) {
        return ImageUtil.wirteBytes(source, "BMP");
    }

    public static byte[] wirtePNGBytes(BufferedImage source) {
        return ImageUtil.wirteBytes(source, "PNG");
    }

    public static byte[] wirteGIFBytes(BufferedImage source) {
        return ImageUtil.wirteBytes(source, "GIF");
    }

    public static byte[] wirteJPEGBytes(BufferedImage source, Float compressionQuality) {
        return ImageUtil.wirteBytes(source, "JPEG", compressionQuality);
    }

    public static byte[] wirteBytes(BufferedImage source, String formatName) {
        return ImageUtil.wirteBytes(source, formatName, null);
    }

    public static byte[] wirteBytes(BufferedImage source, String formatName, Float compressionQuality) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            ImageUtil.wirte(source, formatName, compressionQuality, output);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return output.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wirte(BufferedImage source, String formatName, Float compressionQuality, OutputStream output) throws IOException {
        Assert.notNull(source, "source");
        Assert.notEmpty(formatName, "formatName");
        Assert.notNull(output, "output");
        Graphics g = null;
        try {
            BufferedImage s = source;
            while (!ImageUtil.write(s, formatName, output, compressionQuality)) {
                if (null != g) {
                    throw new IllegalArgumentException(String.format("not found writer for '%s'", formatName));
                }
                s = new BufferedImage(source.getWidth(), source.getHeight(), 1);
                g = s.createGraphics();
                g.drawImage(source, 0, 0, null);
            }
        }
        finally {
            if (null != g) {
                g.dispose();
            }
        }
    }

    public static BufferedImage createThumbnail(BufferedImage source, int thumbnailWidth, int thumbnailHeight, double ratioThreshold) {
        double wh_sca;
        int w = source.getWidth();
        int h = source.getHeight();
        if (w < thumbnailWidth && h < thumbnailHeight) {
            return source.getSubimage(0, 0, w, h);
        }
        double thumAspectRatio = (double)thumbnailWidth / (double)thumbnailHeight;
        double d = wh_sca = w > h ? (double)w / (double)h : (double)h / (double)w;
        if (wh_sca >= ratioThreshold) {
            if (w > h) {
                int fw = (int)(thumAspectRatio * (double)h);
                if (h <= thumbnailHeight) {
                    return source.getSubimage((w - fw) / 2, 0, fw, h);
                }
                return ImageUtil.resize(source.getSubimage((w - fw) / 2, 0, fw, h), thumbnailWidth, thumbnailHeight, true);
            }
            int fh = (int)(thumAspectRatio * (double)w);
            if (w <= thumbnailWidth) {
                return source.getSubimage(0, (h - fh) / 2, w, fh);
            }
            return ImageUtil.resize(source.getSubimage(0, (h - fh) / 2, w, fh), thumbnailWidth, thumbnailHeight, true);
        }
        return ImageUtil.resize(source, thumbnailWidth, thumbnailHeight, true);
    }

    public static byte[] createJPEGThumbnail(byte[] imageBytes, int thumbnailWidth, int thumbnailHeight, double ratioThreshold) {
        Assert.notEmpty(imageBytes, "imageBytes");
        try {
            BufferedImage source = ImageIO.read(new ByteArrayInputStream(imageBytes));
            if (null == source) {
                throw new IllegalArgumentException("unsupported image format");
            }
            BufferedImage thumbnail = ImageUtil.createThumbnail(source, thumbnailWidth, thumbnailHeight, ratioThreshold);
            return ImageUtil.wirteJPEGBytes(thumbnail);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean equalBandOffsetWith3Byte(BufferedImage image, int[] bandOffset) {
        ComponentSampleModel sampleModel;
        return image.getType() == 5 && image.getData().getSampleModel() instanceof ComponentSampleModel && Arrays.equals((sampleModel = (ComponentSampleModel)image.getData().getSampleModel()).getBandOffsets(), bandOffset);
    }

    public static boolean isBGRA(BufferedImage image) {
        return image.getType() == 6 || image.getType() == 7;
    }

    public static boolean isGray(BufferedImage image) {
        return image.getType() == 10;
    }

    public static boolean isBGR3Byte(BufferedImage image) {
        return ImageUtil.equalBandOffsetWith3Byte(image, new int[]{0, 1, 2});
    }

    public static boolean isRGB3Byte(BufferedImage image) {
        return ImageUtil.equalBandOffsetWith3Byte(image, new int[]{2, 1, 0});
    }

    public static byte[] getMatrixRGB(BufferedImage image) {
        byte[] matrixRGB;
        if (null == image) {
            throw new NullPointerException();
        }
        if (ImageUtil.isRGB3Byte(image)) {
            matrixRGB = (byte[])image.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        } else {
            BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            new ColorConvertOp(ColorSpace.getInstance(1000), null).filter(image, rgbImage);
            matrixRGB = (byte[])rgbImage.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        }
        return matrixRGB;
    }

    public static byte[] getMatrixRGBA(BufferedImage image) {
        byte[] matrixRGBA;
        if (null == image) {
            throw new NullPointerException();
        }
        if (ImageUtil.isBGRA(image)) {
            matrixRGBA = (byte[])image.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        } else {
            BufferedImage rgbaImage = new BufferedImage(image.getWidth(), image.getHeight(), 6);
            new ColorConvertOp(ColorSpace.getInstance(1000), null).filter(image, rgbaImage);
            matrixRGBA = (byte[])rgbaImage.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        }
        return matrixRGBA;
    }

    public static byte[] getMatrixBGR(BufferedImage image) {
        byte[] matrixBGR;
        if (null == image) {
            throw new NullPointerException();
        }
        if (ImageUtil.isBGR3Byte(image)) {
            matrixBGR = (byte[])image.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        } else {
            int[] intrgb = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
            matrixBGR = new byte[image.getWidth() * image.getHeight() * 3];
            int i = 0;
            int j = 0;
            while (i < intrgb.length) {
                matrixBGR[j] = (byte)(intrgb[i] & 0xFF);
                matrixBGR[j + 1] = (byte)(intrgb[i] >> 8 & 0xFF);
                matrixBGR[j + 2] = (byte)(intrgb[i] >> 16 & 0xFF);
                ++i;
                j += 3;
            }
        }
        return matrixBGR;
    }

    public static byte[] getMatrixGRAY(BufferedImage image) {
        byte[] matrixGray;
        if (null == image) {
            throw new NullPointerException();
        }
        if (ImageUtil.isGray(image)) {
            matrixGray = (byte[])image.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        } else {
            BufferedImage gray = new BufferedImage(image.getWidth(), image.getHeight(), 10);
            new ColorConvertOp(ColorSpace.getInstance(1003), null).filter(image, gray);
            matrixGray = (byte[])gray.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        }
        return matrixGray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage copy(Image src, int imageType) {
        if (null == src) {
            throw new NullPointerException("src must not be null");
        }
        BufferedImage dst = new BufferedImage(src.getWidth(null), src.getHeight(null), imageType);
        Graphics g = dst.getGraphics();
        try {
            g.drawImage(src, 0, 0, null);
            BufferedImage bufferedImage = dst;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    public static BufferedImage copy(BufferedImage src) {
        return ImageUtil.copy(src, 5);
    }

    public static BufferedImage scale(BufferedImage src, double scale) {
        if (null == src) {
            throw new NullPointerException("src must not be null");
        }
        if (0.0 >= scale) {
            throw new IllegalArgumentException("scale must >0");
        }
        int width = src.getWidth();
        int height = src.getHeight();
        Image image = src.getScaledInstance((int)Math.round((double)width * scale), (int)Math.round((double)height * scale), 4);
        return ImageUtil.copy(image, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage growCanvas(Image src, int imageType, int left, int top, int right, int bottom) {
        if (null == src) {
            throw new NullPointerException("src must not be null");
        }
        if (left < 0 || top < 0 || right < 0 || bottom < 0) {
            throw new IllegalArgumentException("left,top,right,bottom must >=0");
        }
        BufferedImage dst = new BufferedImage(src.getWidth(null) + left + right, src.getHeight(null) + top + bottom, imageType);
        Graphics g = dst.getGraphics();
        try {
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, dst.getWidth(), dst.getHeight());
            g.drawImage(src, left, top, null);
            BufferedImage bufferedImage = dst;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }

    public static BufferedImage growCanvas(Image src, int left, int top, int right, int bottom) {
        return ImageUtil.growCanvas(src, 5, left, top, right, bottom);
    }

    public static BufferedImage growSquareCanvas(Image src) {
        if (null == src) {
            throw new NullPointerException("src must not be null");
        }
        int width = src.getWidth(null);
        int height = src.getHeight(null);
        int size = Math.max(width, height);
        return ImageUtil.growCanvas(src, 5, 0, 0, size - width, size - height);
    }

    private static ImageWriter getImageWriter(RenderedImage im, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(im);
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(RenderedImage source, String formatName, OutputStream output, Float compressionQuality) throws IOException {
        if (null == compressionQuality) {
            return ImageIO.write(source, formatName, output);
        }
        ImageWriter writer = ImageUtil.getImageWriter(source, formatName);
        if (null == writer) {
            return false;
        }
        ImageOutputStream stream = null;
        try {
            stream = ImageIO.createImageOutputStream(output);
        }
        catch (IOException e) {
            throw new IIOException("Can't create output stream!", e);
        }
        writer.setOutput(stream);
        ImageWriteParam param = writer.getDefaultWriteParam();
        try {
            if (param.canWriteCompressed()) {
                try {
                    param.setCompressionMode(2);
                    param.setCompressionQuality(compressionQuality.floatValue());
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            writer.write(null, new IIOImage(source, null, null), param);
            boolean bl = true;
            return bl;
        }
        finally {
            writer.dispose();
            stream.flush();
        }
    }

    public static BufferedImage createRGBImage(byte[] matrixRGB, int width, int height) {
        int bytePerPixel = 3;
        Assert.isTrue(null == matrixRGB || matrixRGB.length == width * height * bytePerPixel, "invalid image argument");
        DataBufferByte dataBuffer = null == matrixRGB ? null : new DataBufferByte(matrixRGB, matrixRGB.length);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bOffs = new int[]{0, 1, 2};
        ComponentColorModel colorModel = new ComponentColorModel(cs, false, false, 1, 0);
        WritableRaster raster = null != dataBuffer ? Raster.createInterleavedRaster(dataBuffer, width, height, width * bytePerPixel, bytePerPixel, bOffs, null) : Raster.createInterleavedRaster(0, width, height, width * bytePerPixel, bytePerPixel, bOffs, null);
        BufferedImage img = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        return img;
    }

    public static BufferedImage createRGBAImage(byte[] matrixRGBA, int width, int height) {
        int bytePerPixel = 4;
        Assert.isTrue(null == matrixRGBA || matrixRGBA.length == width * height * bytePerPixel, "invalid image argument");
        DataBufferByte dataBuffer = null == matrixRGBA ? null : new DataBufferByte(matrixRGBA, matrixRGBA.length);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bOffs = new int[]{0, 1, 2};
        ComponentColorModel colorModel = new ComponentColorModel(cs, false, false, 1, 0);
        WritableRaster raster = null != dataBuffer ? Raster.createInterleavedRaster(dataBuffer, width, height, width * bytePerPixel, bytePerPixel, bOffs, null) : Raster.createInterleavedRaster(0, width, height, width * bytePerPixel, bytePerPixel, bOffs, null);
        BufferedImage img = new BufferedImage(colorModel, raster, colorModel.isAlphaPremultiplied(), null);
        return img;
    }

    private static void assertContains(Rectangle parent, String argParent, Rectangle sub, String argSub) throws IllegalArgumentException {
        if (!parent.contains(sub)) {
            throw new IllegalArgumentException(String.format("the %s(X%d,Y%d,W%d,H%d) not contained by %s(X%d,Y%d,W%d,H%d)", argSub, sub.x, sub.y, sub.width, sub.height, argParent, parent.x, parent.y, parent.width, parent.height));
        }
    }

    public static byte[] cutMatrix(byte[] matrix, Rectangle matrixRect, Rectangle rect) {
        if (rect == null || rect.equals(matrixRect)) {
            return matrix;
        }
        ImageUtil.assertContains(matrixRect, "srcRect", rect, "rect");
        byte[] dstArray = new byte[rect.width * rect.height * 3];
        int dstIndex = 0;
        int srcIndex = (rect.y * matrixRect.width + rect.x) * 3;
        int y = 0;
        while (y < rect.height) {
            System.arraycopy(matrix, srcIndex, dstArray, dstIndex, rect.width * 3);
            ++y;
            srcIndex += matrixRect.width * 3;
            dstIndex += rect.width * 3;
        }
        return dstArray;
    }
}

