/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AccessChecker<ID> {
    protected final Object NULL_OBJ = new Object();
    protected final Cache<ID, Object> cache;
    protected final ConcurrentMap<ID, Object> cacheMap;

    protected AccessChecker(long expireMills) {
        Preconditions.checkArgument(expireMills > 0L, "expireMills must grater than 0");
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(expireMills, TimeUnit.MILLISECONDS).build();
        this.cacheMap = this.cache.asMap();
    }

    public static class BlacklistException
    extends AccessCheckerException {
        private static final long serialVersionUID = 1L;

        public BlacklistException(String arg0) {
            super(arg0);
        }
    }

    public static class FreqException
    extends AccessCheckerException {
        private static final long serialVersionUID = 1L;

        public FreqException(String arg0) {
            super(arg0);
        }
    }

    public static class AddressException
    extends AccessCheckerException {
        private static final long serialVersionUID = 1L;

        public AddressException(String arg0) {
            super(arg0);
        }
    }

    public static class AccessCheckerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public AccessCheckerException() {
        }

        public AccessCheckerException(String arg0) {
            super(arg0);
        }
    }

    public static class BlacklistChecker<ID>
    extends AccessChecker<ID> {
        public BlacklistChecker(long expireMills) {
            super(expireMills);
        }

        public void add(ID id) {
            this.cacheMap.putIfAbsent(id, this.NULL_OBJ);
        }

        public boolean contains(ID id) {
            return null == id ? false : this.cacheMap.containsKey(id);
        }

        public void checkLock(ID id) throws BlacklistException {
            if (this.contains(id)) {
                throw new BlacklistException(String.format("%s is locked by blacklist", id));
            }
        }
    }

    public static class FreqStatChecker<ID>
    extends AccessChecker<ID> {
        private final Cache<ID, AtomicInteger> statCache;
        private final ConcurrentMap<ID, AtomicInteger> statCacheMap;
        private final int hitThreshold;

        public FreqStatChecker(long sampIntervalMills, long statIntervalMills, int hitThreshold) {
            super(sampIntervalMills);
            Preconditions.checkArgument(sampIntervalMills > 0L, "sampIntervalMills must grater than 0");
            Preconditions.checkArgument(statIntervalMills > sampIntervalMills, "statIntervalMills must grater than sampIntervalMills");
            Preconditions.checkArgument(hitThreshold > 0, "hitThreshold must grater than 0");
            this.statCache = CacheBuilder.newBuilder().expireAfterWrite(statIntervalMills, TimeUnit.MILLISECONDS).build();
            this.statCacheMap = this.statCache.asMap();
            this.hitThreshold = hitThreshold;
        }

        public void checkFreq(ID id) throws FreqException {
            AtomicInteger o2;
            AtomicLong o1;
            if (id != null && (o1 = this.cacheMap.putIfAbsent(id, new AtomicLong(1L))) != null && o1.incrementAndGet() == 2L && (o2 = this.statCacheMap.putIfAbsent(id, new AtomicInteger(1))) != null && o2.incrementAndGet() >= this.hitThreshold) {
                throw new FreqException(String.format("%s locked caused by high frequency", id));
            }
        }
    }

    public static class FreqChecker<ID>
    extends AccessChecker<ID> {
        public FreqChecker(long expireMills) {
            super(expireMills);
        }

        public void checkFreq(ID id) throws FreqException {
            Object old;
            if (id != null && (old = this.cacheMap.putIfAbsent(id, this.NULL_OBJ)) != null) {
                throw new FreqException(String.format("%s locked caused by high frequency", id));
            }
        }
    }

    public static class AddressChecker<ID>
    extends AccessChecker<ID> {
        public AddressChecker(long expireMills) {
            super(expireMills);
        }

        public void checkAddress(ID id, Object address) throws AddressException {
            Object old;
            if (id != null && address != null && (old = this.cacheMap.putIfAbsent(id, address)) != null && !old.equals(address)) {
                throw new AddressException(String.format("%s mapped to  %s", id, old));
            }
        }
    }
}

