/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.lang.reflect.Array;
import java.util.Arrays;

public class ArrayUtils {
    private ArrayUtils() {
    }

    public static final <T> T[] cleanNull(T[] array) {
        if (null == array || array.length == 0) {
            return array;
        }
        Object[] copy = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length);
        int c = 0;
        for (int i = 0; i < array.length; ++i) {
            if (null == array[i]) continue;
            copy[c++] = array[i];
        }
        return c == array.length ? array : Arrays.copyOf(copy, c);
    }

    public static int indexOfFirstNull(Object ... objects) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                if (null != objects[i]) continue;
                return i;
            }
            return -1;
        }
        return -2;
    }

    public static boolean hasNull(Object ... objects) {
        return ArrayUtils.indexOfFirstNull(objects) != -1;
    }
}

