/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.gdface.utils.Base64Utils;

public class BinaryUtils {
    private static final String MD5_REGEX = "^[a-fA-F0-9]{32}$";
    private static final String HEX_REGEX = "^([a-fA-F0-9]{2})+$";

    public static final byte[] getMD5(byte[] source) {
        if (null == source) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(source);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getBytesInBuffer(ByteBuffer buffer) {
        if (null == buffer) {
            return null;
        }
        int pos = buffer.position();
        try {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            buffer.position(pos);
        }
    }

    public static final ByteBuffer getMD5(ByteBuffer source) {
        return null == source ? null : ByteBuffer.wrap(BinaryUtils.getMD5(BinaryUtils.getBytesInBuffer(source)));
    }

    public static final String toHex(byte[] buffer) {
        if (null == buffer) {
            return null;
        }
        StringBuffer sb = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            sb.append(Character.forDigit((buffer[i] & 0xF0) >> 4, 16));
            sb.append(Character.forDigit(buffer[i] & 0xF, 16));
        }
        return sb.toString();
    }

    public static final String toHex(ByteBuffer buffer) {
        return BinaryUtils.toHex(BinaryUtils.getBytesInBuffer(buffer));
    }

    public static final boolean validHEX(String input) {
        return input != null && input.matches(HEX_REGEX);
    }

    public static final byte[] hex2Bytes(String src) {
        if (null == src) {
            return null;
        }
        byte[] res = new byte[src.length() / 2];
        char[] chs = src.toCharArray();
        int[] b = new int[2];
        int i = 0;
        int c = 0;
        while (i < chs.length) {
            for (int j = 0; j < 2; ++j) {
                if (chs[i + j] >= '0' && chs[i + j] <= '9') {
                    b[j] = chs[i + j] - 48;
                    continue;
                }
                if (chs[i + j] >= 'A' && chs[i + j] <= 'F') {
                    b[j] = chs[i + j] - 65 + 10;
                    continue;
                }
                if (chs[i + j] < 'a' || chs[i + j] > 'f') continue;
                b[j] = chs[i + j] - 97 + 10;
            }
            b[0] = (b[0] & 0xF) << 4;
            b[1] = b[1] & 0xF;
            res[c] = (byte)(b[0] | b[1]);
            i += 2;
            ++c;
        }
        return res;
    }

    public static final ByteBuffer hex2ByteBuffer(String src) {
        return null == src ? null : ByteBuffer.wrap(BinaryUtils.hex2Bytes(src));
    }

    public static final String getMD5String(byte[] source) {
        return BinaryUtils.toHex(BinaryUtils.getMD5(source));
    }

    public static final String getMD5String(ByteBuffer source) {
        return BinaryUtils.toHex(BinaryUtils.getMD5(source));
    }

    public static final boolean validMd5(String md5) {
        return null != md5 && md5.matches(MD5_REGEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readBytes(InputStream in) throws IOException, IllegalArgumentException {
        if (null == in) {
            return null;
        }
        if (in instanceof FileInputStream) {
            return BinaryUtils.readBytes((FileInputStream)in);
        }
        try {
            int buffSize = Math.max(in.available(), 8192);
            byte[] temp = new byte[buffSize];
            ByteArrayOutputStream out = new ByteArrayOutputStream(buffSize);
            int size = 0;
            while ((size = in.read(temp)) != -1) {
                out.write(temp, 0, size);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readBytes(FileInputStream fin) throws IOException {
        if (null == fin) {
            return null;
        }
        FileChannel fc = fin.getChannel();
        try {
            ByteBuffer bb = ByteBuffer.allocate((int)fc.size());
            fc.read(bb);
            bb.flip();
            byte[] byArray = bb.array();
            return byArray;
        }
        finally {
            if (null != fc) {
                fc.close();
            }
            fin.close();
        }
    }

    public static final <T> InputStream getInputStream(T src) throws IOException, IllegalArgumentException {
        if (null == src) {
            return null;
        }
        if (src instanceof InputStream) {
            return (InputStream)src;
        }
        if (src instanceof String) {
            return new ByteArrayInputStream(Base64Utils.decode((String)src));
        }
        if (src instanceof byte[]) {
            return new ByteArrayInputStream((byte[])src);
        }
        if (src instanceof ByteBuffer) {
            return new ByteArrayInputStream(BinaryUtils.getBytesInBuffer((ByteBuffer)src));
        }
        if (src instanceof File) {
            return new FileInputStream((File)src);
        }
        if (src instanceof URL) {
            return ((URL)src).openStream();
        }
        if (src instanceof URI) {
            return ((URI)src).toURL().openStream();
        }
        throw new IllegalArgumentException(String.format("Can't get inputstream from [%s]", src.getClass().getCanonicalName()));
    }

    public static final <T> byte[] getBytes(T src) throws IOException, IllegalArgumentException {
        if (null == src) {
            return null;
        }
        if (src instanceof byte[]) {
            return (byte[])src;
        }
        if (src instanceof String) {
            return Base64Utils.decode((String)src);
        }
        if (src instanceof ByteBuffer) {
            return BinaryUtils.getBytesInBuffer((ByteBuffer)src);
        }
        if (src instanceof FileInputStream) {
            return BinaryUtils.readBytes((FileInputStream)src);
        }
        if (src instanceof File) {
            return BinaryUtils.readBytes(new FileInputStream((File)src));
        }
        return BinaryUtils.readBytes(BinaryUtils.getInputStream(src));
    }

    public static final <T> byte[] getBytesNotEmpty(T src) throws IOException {
        byte[] imgData = BinaryUtils.getBytes(src);
        if (imgData == null || imgData.length == 0) {
            throw new IOException(String.format("return null or zero length from %s", src.getClass().getSimpleName()));
        }
        return imgData;
    }

    public static final <T> ByteBuffer getByteBuffer(T src) throws IOException, IllegalArgumentException {
        return src == null ? null : ByteBuffer.wrap(BinaryUtils.getBytes(src));
    }

    public static final <T> ByteBuffer getByteBufferNotEmpty(T src) throws IOException, IllegalArgumentException {
        return ByteBuffer.wrap(BinaryUtils.getBytesNotEmpty(src));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final File saveBytes(byte[] data, File file, boolean overwrite) throws IOException, IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        FileOutputStream out = null;
        AbstractInterruptibleChannel fc = null;
        try {
            long free;
            File folder = file.getParentFile();
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if ((free = folder.getFreeSpace() >> 20) < 10L) {
                throw new IOException(String.format("DISK ALMOST FULL(\u78c1\u76d8\u7a7a\u95f4\u4e0d\u8db3) FREE %dMB,%s", free, folder.getAbsolutePath()));
            }
            if (!file.exists() || !file.isFile() || overwrite) {
                out = new FileOutputStream(file);
                fc = out.getChannel();
                ByteBuffer bb = ByteBuffer.wrap(data);
                ((FileChannel)fc).write(bb);
            }
            File file2 = file;
            return file2;
        }
        finally {
            if (null != fc) {
                fc.close();
            }
            if (null != out) {
                out.close();
            }
        }
    }
}

