/*
 * Decompiled with CFR 0.152.
 */
package net.gdface.utils;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClassLoaderUtils {
    public static final String TOOLS_JAR = "${jdk_tools_jar}";
    private static final ThreadLocal<ParentStrategy> parentLoaderStrategy = new ThreadLocal<ParentStrategy>(){

        @Override
        protected ParentStrategy initialValue() {
            return ParentStrategy.currentClassLoader;
        }
    };

    private static final boolean addIfJar(Collection<URL> out, File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            out.add(ClassLoaderUtils.toURL(file));
            return true;
        }
        return false;
    }

    private static final URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static final Set<URL> toJarURLs(File file, final boolean recursive) {
        final HashSet<URL> out = new HashSet<URL>();
        if (!file.exists()) {
            throw new IllegalArgumentException(" not exists:" + file.toString());
        }
        if (file.isFile() && !ClassLoaderUtils.addIfJar(out, file)) {
            throw new IllegalArgumentException(" not jar:" + file.toString());
        }
        if (file.isDirectory()) {
            file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    if (!ClassLoaderUtils.addIfJar(out, pathname) && pathname.isDirectory() && recursive) {
                        out.addAll(ClassLoaderUtils.toJarURLs(pathname, recursive));
                    }
                    return false;
                }
            });
            return out;
        }
        throw new IllegalArgumentException(" invalid file:" + file.toString());
    }

    private static final Set<URL> toJarURLs(String path, boolean recursive) {
        if (null == path || 0 == path.length()) {
            throw new IllegalArgumentException("path must not be  null or empty ");
        }
        return ClassLoaderUtils.toJarURLs(new File(path), recursive);
    }

    private static final Set<URL> toJarURLs(boolean recursive, String ... paths) {
        if (null == paths) {
            throw new NullPointerException("paths is null");
        }
        HashSet<URL> out = new HashSet<URL>();
        for (String path : paths) {
            out.addAll(ClassLoaderUtils.toJarURLs(path, recursive));
        }
        return out;
    }

    private static final Set<URL> toJarURLs(String ... classpath) {
        if (null == classpath) {
            throw new NullPointerException("classpaths is null");
        }
        HashSet<URL> out = new HashSet<URL>();
        for (String path : classpath) {
            File file;
            if (null == path || 0 == path.length()) {
                throw new IllegalArgumentException("classPaths have null or empty element");
            }
            if (path.equals(TOOLS_JAR)) {
                path = ClassLoaderUtils.getJdkToolsJar();
            }
            if (!(file = new File(path)).exists()) {
                throw new IllegalArgumentException("no exists : " + file);
            }
            if (file.isFile()) {
                if (ClassLoaderUtils.addIfJar(out, file)) continue;
                throw new IllegalArgumentException("not jar:" + file);
            }
            if (!file.isDirectory()) continue;
            out.add(ClassLoaderUtils.toURL(file));
        }
        return out;
    }

    private static final Set<URL> toJarURLs(boolean recursive, String[] libdirs, String[] classpath) {
        HashSet<URL> out = new HashSet<URL>();
        if (null != libdirs) {
            out.addAll(ClassLoaderUtils.toJarURLs(recursive, libdirs));
        }
        if (null != classpath) {
            out.addAll(ClassLoaderUtils.toJarURLs(classpath));
        }
        return out;
    }

    public static final URLClassLoader makeURLClassLoader(ClassLoader parent, String ... classpath) {
        return ClassLoaderUtils.makeURLClassLoader(parent, false, null, classpath);
    }

    public static final URLClassLoader makeURLClassLoader(ClassLoader parent, boolean recursive, String ... libdirs) {
        return ClassLoaderUtils.makeURLClassLoader(parent, recursive, libdirs, null);
    }

    public static final URLClassLoader makeURLClassLoader(ClassLoader parent, boolean recursive, String[] libdirs, String[] classpath) {
        Set<URL> out = ClassLoaderUtils.toJarURLs(recursive, libdirs, classpath);
        if (out.isEmpty()) {
            throw new IllegalArgumentException("empty libdirs and classpath");
        }
        if (null == parent) {
            switch (parentLoaderStrategy.get()) {
                case defaultParentLoader: {
                    return URLClassLoader.newInstance(out.toArray(new URL[out.size()]));
                }
                case threadContextLoader: {
                    parent = Thread.currentThread().getContextClassLoader();
                    break;
                }
                case currentClassLoader: {
                    parent = ClassLoaderUtils.class.getClassLoader();
                }
            }
        }
        return URLClassLoader.newInstance(out.toArray(new URL[out.size()]), parent);
    }

    public static final URLClassLoader makeURLClassLoader(ClassLoader parent, boolean recursive, Collection<String> libdirs, Collection<String> classpath) {
        return ClassLoaderUtils.makeURLClassLoader(parent, recursive, null == libdirs ? null : libdirs.toArray(new String[0]), null == classpath ? null : classpath.toArray(new String[0]));
    }

    public static final void setParentLoaderStrategy(ParentStrategy parentLoaderStrategy) {
        ClassLoaderUtils.parentLoaderStrategy.set(null == parentLoaderStrategy ? ParentStrategy.currentClassLoader : parentLoaderStrategy);
    }

    public static final void setParentLoaderStrategy(String parentLoaderStrategy) {
        ClassLoaderUtils.setParentLoaderStrategy(ParentStrategy.valueOf(parentLoaderStrategy));
    }

    public static String getJdkToolsJar() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("java.home")).append(File.separatorChar);
        if (System.getProperty("os.name").indexOf("Mac OS") < 0) {
            buffer.append("..").append(File.separatorChar).append("lib").append(File.separatorChar).append("tools.jar");
        } else {
            buffer.append("../Classes/classes.jar");
        }
        return buffer.toString();
    }

    public static enum ParentStrategy {
        defaultParentLoader,
        threadContextLoader,
        currentClassLoader;

    }
}

